@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GoogleAdWordsLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.GoogleAdWordsAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Google AdWords service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
 * @property clientCustomerID The Client customer ID of the AdWords account that you want to fetch report data for. Type: string (or Expression with resultType string).
 * @property clientId The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret of the google application used to acquire the refresh token.
 * @property connectVia The integration runtime reference.
 * @property connectionProperties (Deprecated) Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked service. Type: object.
 * @property description Linked service description.
 * @property developerToken The developer token associated with the manager account that you use to grant access to the AdWords API.
 * @property email The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property googleAdsApiVersion The Google Ads API major version such as v14. The supported major versions could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression with resultType string).
 * @property keyFilePath (Deprecated) The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property loginCustomerID The customer ID of the Google Ads Manager account through which you want to fetch report data of specific Customer. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property privateKey The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
 * @property refreshToken The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
 * @property supportLegacyDataTypes Specifies whether to use the legacy data type mappings, which maps float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
 * @property trustedCertPath (Deprecated) The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'GoogleAdWords'.
 * @property useSystemTrustStore (Deprecated) Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with resultType boolean).
 */
public data class GoogleAdWordsLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, GoogleAdWordsAuthenticationType>>? = null,
    public val clientCustomerID: Output<Any>? = null,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionProperties: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val developerToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val email: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val googleAdsApiVersion: Output<Any>? = null,
    public val keyFilePath: Output<Any>? = null,
    public val loginCustomerID: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val privateKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val refreshToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val supportLegacyDataTypes: Output<Any>? = null,
    public val trustedCertPath: Output<Any>? = null,
    public val type: Output<String>,
    public val useSystemTrustStore: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GoogleAdWordsLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GoogleAdWordsLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.GoogleAdWordsLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientCustomerID(clientCustomerID?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionProperties(connectionProperties?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .developerToken(
                developerToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .email(email?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .googleAdsApiVersion(googleAdsApiVersion?.applyValue({ args0 -> args0 }))
            .keyFilePath(keyFilePath?.applyValue({ args0 -> args0 }))
            .loginCustomerID(loginCustomerID?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .privateKey(
                privateKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .refreshToken(
                refreshToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .supportLegacyDataTypes(supportLegacyDataTypes?.applyValue({ args0 -> args0 }))
            .trustedCertPath(trustedCertPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useSystemTrustStore(useSystemTrustStore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GoogleAdWordsLinkedServiceArgs].
 */
@PulumiTagMarker
public class GoogleAdWordsLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, GoogleAdWordsAuthenticationType>>? = null

    private var clientCustomerID: Output<Any>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionProperties: Output<Any>? = null

    private var description: Output<String>? = null

    private var developerToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var email: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var googleAdsApiVersion: Output<Any>? = null

    private var keyFilePath: Output<Any>? = null

    private var loginCustomerID: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var privateKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var refreshToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var supportLegacyDataTypes: Output<Any>? = null

    private var trustedCertPath: Output<Any>? = null

    private var type: Output<String>? = null

    private var useSystemTrustStore: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("cciibtwpfdxwamdo")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("cbwussdtbrrvkdwt")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("dlovjxftiucdeoxn")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("einbdjvmlkcwvtmg")
    public suspend
    fun authenticationType(`value`: Output<Either<String, GoogleAdWordsAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The Client customer ID of the AdWords account that you want to fetch report data for. Type: string (or Expression with resultType string).
     */
    @JvmName("hauetjcyxohqdros")
    public suspend fun clientCustomerID(`value`: Output<Any>) {
        this.clientCustomerID = value
    }

    /**
     * @param value The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JvmName("amppywqpsqerqghn")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("ynpxfvadrbfjleys")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("daotroagbohnafov")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value (Deprecated) Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JvmName("knotnxjkvjdtfayy")
    public suspend fun connectionProperties(`value`: Output<Any>) {
        this.connectionProperties = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("bqgrwybxbuxuoivn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The developer token associated with the manager account that you use to grant access to the AdWords API.
     */
    @JvmName("nyuphqtdiigidqxa")
    public suspend
    fun developerToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.developerToken = value
    }

    /**
     * @param value The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("wptjhyoikjbndqpf")
    public suspend fun email(`value`: Output<Any>) {
        this.email = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("dfngvmlejonvrydm")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The Google Ads API major version such as v14. The supported major versions could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression with resultType string).
     */
    @JvmName("seikwonunfejjxmn")
    public suspend fun googleAdsApiVersion(`value`: Output<Any>) {
        this.googleAdsApiVersion = value
    }

    /**
     * @param value (Deprecated) The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("ivfvxbssbebgoqta")
    public suspend fun keyFilePath(`value`: Output<Any>) {
        this.keyFilePath = value
    }

    /**
     * @param value The customer ID of the Google Ads Manager account through which you want to fetch report data of specific Customer. Type: string (or Expression with resultType string).
     */
    @JvmName("yjrqfoambrykhrbb")
    public suspend fun loginCustomerID(`value`: Output<Any>) {
        this.loginCustomerID = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("idhtpaptkfxhvbbs")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
     */
    @JvmName("ndxqoqtbegukagbv")
    public suspend
    fun privateKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.privateKey = value
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
     */
    @JvmName("ffualutptdanktbm")
    public suspend
    fun refreshToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.refreshToken = value
    }

    /**
     * @param value Specifies whether to use the legacy data type mappings, which maps float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("arqtxxhrssukrfhv")
    public suspend fun supportLegacyDataTypes(`value`: Output<Any>) {
        this.supportLegacyDataTypes = value
    }

    /**
     * @param value (Deprecated) The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
     */
    @JvmName("ynnwnuwpxbxwwmnq")
    public suspend fun trustedCertPath(`value`: Output<Any>) {
        this.trustedCertPath = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'GoogleAdWords'.
     */
    @JvmName("erbbgujoyyduhqgf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value (Deprecated) Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jutjstqwmhdgkbfh")
    public suspend fun useSystemTrustStore(`value`: Output<Any>) {
        this.useSystemTrustStore = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("srdxuvqbuacrdqtu")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("mnrphmkbqvfvkxuy")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("mdceaoauydqxgvwy")
    public suspend fun authenticationType(`value`: Either<String, GoogleAdWordsAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("dxmhydxtekqyamdi")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GoogleAdWordsAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("mqacgjehdlyorfdd")
    public fun authenticationType(`value`: GoogleAdWordsAuthenticationType) {
        val toBeMapped = Either.ofRight<String, GoogleAdWordsAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The Client customer ID of the AdWords account that you want to fetch report data for. Type: string (or Expression with resultType string).
     */
    @JvmName("yoisvorjeiltkkfq")
    public suspend fun clientCustomerID(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCustomerID = mapped
    }

    /**
     * @param value The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JvmName("nfcvxbtcxceqpbwi")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("yjiuokwqtlpukhcf")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("vfdaypnsaaspmfti")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("cypgmlofbtxsylhu")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("melbnwcuexpnevcy")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("bvbwaphncnagkduq")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value (Deprecated) Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked service. Type: object.
     */
    @JvmName("eftdrdlfaixiaxvl")
    public suspend fun connectionProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProperties = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("tqaoeqemnutapdca")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The developer token associated with the manager account that you use to grant access to the AdWords API.
     */
    @JvmName("mwmdobqxdcexwsmi")
    public suspend
    fun developerToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerToken = mapped
    }

    /**
     * @param value The developer token associated with the manager account that you use to grant access to the AdWords API.
     */
    @JvmName("yhkoumfilqdkuaml")
    public fun developerToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.developerToken = mapped
    }

    /**
     * @param value The developer token associated with the manager account that you use to grant access to the AdWords API.
     */
    @JvmName("shofrapvwndrprqq")
    public fun developerToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.developerToken = mapped
    }

    /**
     * @param value The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("cmojcmfimfjswoex")
    public suspend fun email(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("kcibmxshyouowghf")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The Google Ads API major version such as v14. The supported major versions could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression with resultType string).
     */
    @JvmName("cdtqhugtfjdkcfwx")
    public suspend fun googleAdsApiVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleAdsApiVersion = mapped
    }

    /**
     * @param value (Deprecated) The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("cbybkmoeoarhppyg")
    public suspend fun keyFilePath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFilePath = mapped
    }

    /**
     * @param value The customer ID of the Google Ads Manager account through which you want to fetch report data of specific Customer. Type: string (or Expression with resultType string).
     */
    @JvmName("desbiqysfgbloour")
    public suspend fun loginCustomerID(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginCustomerID = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hqbvqirpotrpumdv")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("gbunkbibyhfdttvo")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("evgunmrtjyegsjeu")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
     */
    @JvmName("jnnbiomopdbvyxep")
    public suspend
    fun privateKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
     */
    @JvmName("lqsruchbdfhegmgq")
    public fun privateKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
     */
    @JvmName("dshtamodpidlueui")
    public fun privateKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
     */
    @JvmName("aidksvvkextivysu")
    public suspend
    fun refreshToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
     */
    @JvmName("qabtsmkpyjauhwwv")
    public fun refreshToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
     */
    @JvmName("dralnssohobbavar")
    public fun refreshToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value Specifies whether to use the legacy data type mappings, which maps float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("mmpxeglmhoxqrxhj")
    public suspend fun supportLegacyDataTypes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportLegacyDataTypes = mapped
    }

    /**
     * @param value (Deprecated) The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
     */
    @JvmName("bwwfixvicckjmnja")
    public suspend fun trustedCertPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCertPath = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'GoogleAdWords'.
     */
    @JvmName("todtfycomyxyvekg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value (Deprecated) Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ayasyfoyyhsupyik")
    public suspend fun useSystemTrustStore(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSystemTrustStore = mapped
    }

    internal fun build(): GoogleAdWordsLinkedServiceArgs = GoogleAdWordsLinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType,
        clientCustomerID = clientCustomerID,
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        connectionProperties = connectionProperties,
        description = description,
        developerToken = developerToken,
        email = email,
        encryptedCredential = encryptedCredential,
        googleAdsApiVersion = googleAdsApiVersion,
        keyFilePath = keyFilePath,
        loginCustomerID = loginCustomerID,
        parameters = parameters,
        privateKey = privateKey,
        refreshToken = refreshToken,
        supportLegacyDataTypes = supportLegacyDataTypes,
        trustedCertPath = trustedCertPath,
        type = type ?: throw PulumiNullFieldException("type"),
        useSystemTrustStore = useSystemTrustStore,
    )
}
