@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.GoogleBigQueryAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Google BigQuery service linked service.
 * @property additionalProjects A comma-separated list of public BigQuery projects to access. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
 * @property clientId The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret of the google application used to acquire the refresh token.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property email The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property keyFilePath The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property project The default BigQuery project to query against. Type: string (or Expression with resultType string).
 * @property refreshToken The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
 * @property requestGoogleDriveScope Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false. Type: string (or Expression with resultType string).
 * @property trustedCertPath The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'GoogleBigQuery'.
 * @property useSystemTrustStore Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.Type: boolean (or Expression with resultType boolean).
 */
public data class GoogleBigQueryLinkedServiceArgs(
    public val additionalProjects: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, GoogleBigQueryAuthenticationType>>,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val email: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val keyFilePath: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val project: Output<Any>,
    public val refreshToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val requestGoogleDriveScope: Output<Any>? = null,
    public val trustedCertPath: Output<Any>? = null,
    public val type: Output<String>,
    public val useSystemTrustStore: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryLinkedServiceArgs.builder()
            .additionalProjects(additionalProjects?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .keyFilePath(keyFilePath?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .project(project.applyValue({ args0 -> args0 }))
            .refreshToken(
                refreshToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .requestGoogleDriveScope(requestGoogleDriveScope?.applyValue({ args0 -> args0 }))
            .trustedCertPath(trustedCertPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useSystemTrustStore(useSystemTrustStore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GoogleBigQueryLinkedServiceArgs].
 */
@PulumiTagMarker
public class GoogleBigQueryLinkedServiceArgsBuilder internal constructor() {
    private var additionalProjects: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, GoogleBigQueryAuthenticationType>>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var email: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var keyFilePath: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var project: Output<Any>? = null

    private var refreshToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var requestGoogleDriveScope: Output<Any>? = null

    private var trustedCertPath: Output<Any>? = null

    private var type: Output<String>? = null

    private var useSystemTrustStore: Output<Any>? = null

    /**
     * @param value A comma-separated list of public BigQuery projects to access. Type: string (or Expression with resultType string).
     */
    @JvmName("bqirjenudfecsxnu")
    public suspend fun additionalProjects(`value`: Output<Any>) {
        this.additionalProjects = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lgacmdfsqluftiyr")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("nwolnjlgldpesdni")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("rsiojdprbmkaxhjc")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("mrjqgjdmqlxirxoc")
    public suspend
    fun authenticationType(`value`: Output<Either<String, GoogleBigQueryAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JvmName("beuebimmygrlqdbp")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("wxvxilpmaeufbwmy")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("fkluqxncgphphteg")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("shabofrisnntskwb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("caqnymbismcyubff")
    public suspend fun email(`value`: Output<Any>) {
        this.email = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("erovrksmrkrybvtx")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("nbsnlgkmekwepijd")
    public suspend fun keyFilePath(`value`: Output<Any>) {
        this.keyFilePath = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ctkafauophduypak")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The default BigQuery project to query against. Type: string (or Expression with resultType string).
     */
    @JvmName("jmvwaghhtxsxuoxb")
    public suspend fun project(`value`: Output<Any>) {
        this.project = value
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("imnyxxkljtcaronp")
    public suspend
    fun refreshToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.refreshToken = value
    }

    /**
     * @param value Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false. Type: string (or Expression with resultType string).
     */
    @JvmName("twuddwghffwfyvbw")
    public suspend fun requestGoogleDriveScope(`value`: Output<Any>) {
        this.requestGoogleDriveScope = value
    }

    /**
     * @param value The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
     */
    @JvmName("lmoyfktiirlafvlk")
    public suspend fun trustedCertPath(`value`: Output<Any>) {
        this.trustedCertPath = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'GoogleBigQuery'.
     */
    @JvmName("mcdbxwwjyvlqjcba")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tupshmaqccvmbyif")
    public suspend fun useSystemTrustStore(`value`: Output<Any>) {
        this.useSystemTrustStore = value
    }

    /**
     * @param value A comma-separated list of public BigQuery projects to access. Type: string (or Expression with resultType string).
     */
    @JvmName("vpoijlkmtkgtcwkf")
    public suspend fun additionalProjects(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalProjects = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("crqibyyfpgwrdein")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("foehkqjhqdgoapyy")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("htltcswdqviynjqc")
    public suspend fun authenticationType(`value`: Either<String, GoogleBigQueryAuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("xpjlwccnkaiumona")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GoogleBigQueryAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
     */
    @JvmName("quqiepsefclxklxc")
    public fun authenticationType(`value`: GoogleBigQueryAuthenticationType) {
        val toBeMapped = Either.ofRight<String, GoogleBigQueryAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JvmName("jwdkfiwskhhtywcp")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("lxqbhfyumdvwyxlb")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("krsngcfanwdxnapv")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("glapntdmkhjbqukh")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("dryxraqqjebiugub")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("bufaldfrcksuvqck")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("vlrdgkopdhsryrtm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("btagrrxaolrqjwjx")
    public suspend fun email(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("uuamdwwcxlsmpgdk")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
     */
    @JvmName("mgkwwwosondybnwh")
    public suspend fun keyFilePath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFilePath = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("naycchktkagrfdnv")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("sxhxynkqyqdyapuw")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("xfprjivwrenphari")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The default BigQuery project to query against. Type: string (or Expression with resultType string).
     */
    @JvmName("rcgweklpuhhyjqqo")
    public suspend fun project(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("rtuwbgcaiqtgvmbo")
    public suspend
    fun refreshToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("ivbcabnxuqwmaeur")
    public fun refreshToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("kbobjecihowhpfed")
    public fun refreshToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false. Type: string (or Expression with resultType string).
     */
    @JvmName("dhbtygqsukpcnijh")
    public suspend fun requestGoogleDriveScope(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestGoogleDriveScope = mapped
    }

    /**
     * @param value The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
     */
    @JvmName("rucuoywqogcnkwyb")
    public suspend fun trustedCertPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCertPath = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'GoogleBigQuery'.
     */
    @JvmName("efnplpglwqqfurwg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("kpwlklvdqskvfnan")
    public suspend fun useSystemTrustStore(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSystemTrustStore = mapped
    }

    internal fun build(): GoogleBigQueryLinkedServiceArgs = GoogleBigQueryLinkedServiceArgs(
        additionalProjects = additionalProjects,
        annotations = annotations,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        description = description,
        email = email,
        encryptedCredential = encryptedCredential,
        keyFilePath = keyFilePath,
        parameters = parameters,
        project = project ?: throw PulumiNullFieldException("project"),
        refreshToken = refreshToken,
        requestGoogleDriveScope = requestGoogleDriveScope,
        trustedCertPath = trustedCertPath,
        type = type ?: throw PulumiNullFieldException("type"),
        useSystemTrustStore = useSystemTrustStore,
    )
}
