@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HBaseLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.HBaseAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * HBase server linked service.
 * @property allowHostNameCNMismatch Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
 * @property allowSelfSignedServerCert Specifies whether to allow self-signed certificates from the server. The default value is false.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication mechanism to use to connect to the HBase server.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property enableSsl Specifies whether the connections to the server are encrypted using SSL. The default value is false.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The IP address or host name of the HBase server. (i.e. 192.168.222.160)
 * @property httpPath The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
 * @property parameters Parameters for linked service.
 * @property password The password corresponding to the user name.
 * @property port The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
 * @property trustedCertPath The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
 * @property type Type of linked service.
 * Expected value is 'HBase'.
 * @property username The user name used to connect to the HBase instance.
 */
public data class HBaseLinkedServiceArgs(
    public val allowHostNameCNMismatch: Output<Any>? = null,
    public val allowSelfSignedServerCert: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, HBaseAuthenticationType>>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val enableSsl: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>,
    public val httpPath: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val port: Output<Any>? = null,
    public val trustedCertPath: Output<Any>? = null,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HBaseLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HBaseLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.HBaseLinkedServiceArgs.builder()
            .allowHostNameCNMismatch(allowHostNameCNMismatch?.applyValue({ args0 -> args0 }))
            .allowSelfSignedServerCert(allowSelfSignedServerCert?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableSsl(enableSsl?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .httpPath(httpPath?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .trustedCertPath(trustedCertPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HBaseLinkedServiceArgs].
 */
@PulumiTagMarker
public class HBaseLinkedServiceArgsBuilder internal constructor() {
    private var allowHostNameCNMismatch: Output<Any>? = null

    private var allowSelfSignedServerCert: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, HBaseAuthenticationType>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var enableSsl: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var httpPath: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var port: Output<Any>? = null

    private var trustedCertPath: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
     */
    @JvmName("unljaxppmdiravkd")
    public suspend fun allowHostNameCNMismatch(`value`: Output<Any>) {
        this.allowHostNameCNMismatch = value
    }

    /**
     * @param value Specifies whether to allow self-signed certificates from the server. The default value is false.
     */
    @JvmName("ardycyvlxcvvxswn")
    public suspend fun allowSelfSignedServerCert(`value`: Output<Any>) {
        this.allowSelfSignedServerCert = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("kespffrobryrkiii")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("pfvjydtgyjyhmqei")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hypbpbsgpowtvpbk")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The authentication mechanism to use to connect to the HBase server.
     */
    @JvmName("bsntynkdbqlfcpqp")
    public suspend fun authenticationType(`value`: Output<Either<String, HBaseAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("cqkhhbkgxhjamukj")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("bdrvchejluqrnoqv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether the connections to the server are encrypted using SSL. The default value is false.
     */
    @JvmName("bgkaihsntbygrips")
    public suspend fun enableSsl(`value`: Output<Any>) {
        this.enableSsl = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("accimpdakfdcqaar")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The IP address or host name of the HBase server. (i.e. 192.168.222.160)
     */
    @JvmName("mucqmwjqveefukri")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
     */
    @JvmName("mvaovvinkjnsvtgu")
    public suspend fun httpPath(`value`: Output<Any>) {
        this.httpPath = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("dwdhxfqlgpwmsdty")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password corresponding to the user name.
     */
    @JvmName("siemmaivrgeuwpbu")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
     */
    @JvmName("mpemnfqmeftwvpxv")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
     */
    @JvmName("xhnichwhungxtygu")
    public suspend fun trustedCertPath(`value`: Output<Any>) {
        this.trustedCertPath = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HBase'.
     */
    @JvmName("ktbywsoabbhvagcm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name used to connect to the HBase instance.
     */
    @JvmName("nibhqnxjptbwhwxl")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
     */
    @JvmName("wcahnjwycefsngub")
    public suspend fun allowHostNameCNMismatch(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHostNameCNMismatch = mapped
    }

    /**
     * @param value Specifies whether to allow self-signed certificates from the server. The default value is false.
     */
    @JvmName("ajvxutghjjpkmrtp")
    public suspend fun allowSelfSignedServerCert(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSelfSignedServerCert = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("danskulwstffyoio")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("eqmljfrommoebxkh")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The authentication mechanism to use to connect to the HBase server.
     */
    @JvmName("xigmlhqpqmpmlyvw")
    public suspend fun authenticationType(`value`: Either<String, HBaseAuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication mechanism to use to connect to the HBase server.
     */
    @JvmName("nwruhxdmiceufhju")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HBaseAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication mechanism to use to connect to the HBase server.
     */
    @JvmName("vgispvojpkdiweyq")
    public fun authenticationType(`value`: HBaseAuthenticationType) {
        val toBeMapped = Either.ofRight<String, HBaseAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("sxrpkjwsjdlghflm")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("lbbtldysnduqlkvc")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("qbiwrxmabqtymvyf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether the connections to the server are encrypted using SSL. The default value is false.
     */
    @JvmName("lnftoywshgcloklc")
    public suspend fun enableSsl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsl = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("dbpdyysrmldghrji")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The IP address or host name of the HBase server. (i.e. 192.168.222.160)
     */
    @JvmName("nefwybuyykunhhlv")
    public suspend fun host(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
     */
    @JvmName("hemlolvlavmstspg")
    public suspend fun httpPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPath = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("eqeldxhymjvjbfeo")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ebgrmhdwwiyjrnan")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("bspjuluhjawgpfsq")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password corresponding to the user name.
     */
    @JvmName("atolcdheadwscxoy")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name.
     */
    @JvmName("xgqnvscndgsshjkq")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name.
     */
    @JvmName("deidwxncxukqsbau")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
     */
    @JvmName("uwcjrylvatcvgxel")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
     */
    @JvmName("qtjmmgcdrjojnppe")
    public suspend fun trustedCertPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCertPath = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'HBase'.
     */
    @JvmName("ciypjahsgfudavrd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name used to connect to the HBase instance.
     */
    @JvmName("esuvdpqdcbxrfgeh")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): HBaseLinkedServiceArgs = HBaseLinkedServiceArgs(
        allowHostNameCNMismatch = allowHostNameCNMismatch,
        allowSelfSignedServerCert = allowSelfSignedServerCert,
        annotations = annotations,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        connectVia = connectVia,
        description = description,
        enableSsl = enableSsl,
        encryptedCredential = encryptedCredential,
        host = host ?: throw PulumiNullFieldException("host"),
        httpPath = httpPath,
        parameters = parameters,
        password = password,
        port = port,
        trustedCertPath = trustedCertPath,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
