@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HDFS read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property distcpSettings Specifies Distcp-related settings.
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'HdfsReadSettings'.
 * @property wildcardFileName HDFS wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class HdfsReadSettingsArgs(
    public val deleteFilesAfterCompletion: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val distcpSettings: Output<DistcpSettingsArgs>? = null,
    public val enablePartitionDiscovery: Output<Any>? = null,
    public val fileListPath: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val partitionRootPath: Output<Any>? = null,
    public val recursive: Output<Any>? = null,
    public val type: Output<String>,
    public val wildcardFileName: Output<Any>? = null,
    public val wildcardFolderPath: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.HdfsReadSettingsArgs.builder()
            .deleteFilesAfterCompletion(deleteFilesAfterCompletion?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .distcpSettings(distcpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enablePartitionDiscovery(enablePartitionDiscovery?.applyValue({ args0 -> args0 }))
            .fileListPath(fileListPath?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .partitionRootPath(partitionRootPath?.applyValue({ args0 -> args0 }))
            .recursive(recursive?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .wildcardFileName(wildcardFileName?.applyValue({ args0 -> args0 }))
            .wildcardFolderPath(wildcardFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HdfsReadSettingsArgs].
 */
@PulumiTagMarker
public class HdfsReadSettingsArgsBuilder internal constructor() {
    private var deleteFilesAfterCompletion: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var distcpSettings: Output<DistcpSettingsArgs>? = null

    private var enablePartitionDiscovery: Output<Any>? = null

    private var fileListPath: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var partitionRootPath: Output<Any>? = null

    private var recursive: Output<Any>? = null

    private var type: Output<String>? = null

    private var wildcardFileName: Output<Any>? = null

    private var wildcardFolderPath: Output<Any>? = null

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ikqamfkkmkruxmww")
    public suspend fun deleteFilesAfterCompletion(`value`: Output<Any>) {
        this.deleteFilesAfterCompletion = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("eeycyjloutwjctnj")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Specifies Distcp-related settings.
     */
    @JvmName("nboicflqdxlsfeqo")
    public suspend fun distcpSettings(`value`: Output<DistcpSettingsArgs>) {
        this.distcpSettings = value
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jmkemcynslphxefu")
    public suspend fun enablePartitionDiscovery(`value`: Output<Any>) {
        this.enablePartitionDiscovery = value
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("ovfclqvypqqoxwiw")
    public suspend fun fileListPath(`value`: Output<Any>) {
        this.fileListPath = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("htmacevpmqqeitkm")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("cbjvrvhmuotsyten")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("kgkrpysxicbtqewh")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("nnblubhgiyhnlajw")
    public suspend fun partitionRootPath(`value`: Output<Any>) {
        this.partitionRootPath = value
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("pwcsrnlaisbmjgcj")
    public suspend fun recursive(`value`: Output<Any>) {
        this.recursive = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'HdfsReadSettings'.
     */
    @JvmName("egyglnnodrbrbdyc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value HDFS wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("nrpkurlnfftkbonm")
    public suspend fun wildcardFileName(`value`: Output<Any>) {
        this.wildcardFileName = value
    }

    /**
     * @param value HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("poieefxvouiypxui")
    public suspend fun wildcardFolderPath(`value`: Output<Any>) {
        this.wildcardFolderPath = value
    }

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("pwvlscgivfyphrcp")
    public suspend fun deleteFilesAfterCompletion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteFilesAfterCompletion = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gfipdmnckrqwxgps")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Specifies Distcp-related settings.
     */
    @JvmName("qprcrttghecaoaiq")
    public suspend fun distcpSettings(`value`: DistcpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distcpSettings = mapped
    }

    /**
     * @param argument Specifies Distcp-related settings.
     */
    @JvmName("pidrcenqirnddpaf")
    public suspend fun distcpSettings(argument: suspend DistcpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DistcpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.distcpSettings = mapped
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("sfueixsbgaxbdtis")
    public suspend fun enablePartitionDiscovery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitionDiscovery = mapped
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("qkmxcafpraeuwbnt")
    public suspend fun fileListPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileListPath = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("fjgbaihbfvrnfimn")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("iaespsbskwrnurdu")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("epoushdgauixsxcv")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("qtyseljybhfsitsh")
    public suspend fun partitionRootPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionRootPath = mapped
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tvmoetryykdevwbv")
    public suspend fun recursive(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recursive = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'HdfsReadSettings'.
     */
    @JvmName("wxwfmtmqlslwkhhe")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value HDFS wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("msipvswqgndfjncn")
    public suspend fun wildcardFileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFileName = mapped
    }

    /**
     * @param value HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("orcujpdpaqkotsnr")
    public suspend fun wildcardFolderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFolderPath = mapped
    }

    internal fun build(): HdfsReadSettingsArgs = HdfsReadSettingsArgs(
        deleteFilesAfterCompletion = deleteFilesAfterCompletion,
        disableMetricsCollection = disableMetricsCollection,
        distcpSettings = distcpSettings,
        enablePartitionDiscovery = enablePartitionDiscovery,
        fileListPath = fileListPath,
        maxConcurrentConnections = maxConcurrentConnections,
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        partitionRootPath = partitionRootPath,
        recursive = recursive,
        type = type ?: throw PulumiNullFieldException("type"),
        wildcardFileName = wildcardFileName,
        wildcardFolderPath = wildcardFolderPath,
    )
}
