@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HttpServerLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of http server.
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property relativeUrl Specify the relativeUrl of http server. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'HttpServerLocation'.
 */
public data class HttpServerLocationArgs(
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val relativeUrl: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HttpServerLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HttpServerLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.HttpServerLocationArgs.builder()
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .relativeUrl(relativeUrl?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpServerLocationArgs].
 */
@PulumiTagMarker
public class HttpServerLocationArgsBuilder internal constructor() {
    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var relativeUrl: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("vtwgcquaslbcwnjs")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("fthkepmtdcbpidbw")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Specify the relativeUrl of http server. Type: string (or Expression with resultType string)
     */
    @JvmName("blewjataalhahban")
    public suspend fun relativeUrl(`value`: Output<Any>) {
        this.relativeUrl = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'HttpServerLocation'.
     */
    @JvmName("stmkgptapeewihus")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("nwetvmidfntsgxfp")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("wljmeqksgiowbuno")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Specify the relativeUrl of http server. Type: string (or Expression with resultType string)
     */
    @JvmName("ftiwhodliivamdcq")
    public suspend fun relativeUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativeUrl = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'HttpServerLocation'.
     */
    @JvmName("mnjdexfuhywnpbkm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): HttpServerLocationArgs = HttpServerLocationArgs(
        fileName = fileName,
        folderPath = folderPath,
        relativeUrl = relativeUrl,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
