@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.DataFlowComputeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data flow properties for managed integration runtime.
 * @property cleanup Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if this is set as false. Default is true.
 * @property computeType Compute type of the cluster which will execute data flow job.
 * @property coreCount Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
 * @property customProperties Custom properties are used to tune the data flow runtime performance.
 * @property timeToLive Time to live (in minutes) setting of the cluster which will execute data flow job.
 */
public data class IntegrationRuntimeDataFlowPropertiesArgs(
    public val cleanup: Output<Boolean>? = null,
    public val computeType: Output<Either<String, DataFlowComputeType>>? = null,
    public val coreCount: Output<Int>? = null,
    public val customProperties:
    Output<List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs>>? = null,
    public val timeToLive: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesArgs.builder()
            .cleanup(cleanup?.applyValue({ args0 -> args0 }))
            .computeType(
                computeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .coreCount(coreCount?.applyValue({ args0 -> args0 }))
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeToLive(timeToLive?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeDataFlowPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeDataFlowPropertiesArgsBuilder internal constructor() {
    private var cleanup: Output<Boolean>? = null

    private var computeType: Output<Either<String, DataFlowComputeType>>? = null

    private var coreCount: Output<Int>? = null

    private var customProperties:
        Output<List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs>>? = null

    private var timeToLive: Output<Int>? = null

    /**
     * @param value Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if this is set as false. Default is true.
     */
    @JvmName("widgkhrrcswidfmq")
    public suspend fun cleanup(`value`: Output<Boolean>) {
        this.cleanup = value
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("fljvkvginjvxqutj")
    public suspend fun computeType(`value`: Output<Either<String, DataFlowComputeType>>) {
        this.computeType = value
    }

    /**
     * @param value Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
     */
    @JvmName("meiyenblhhysbqge")
    public suspend fun coreCount(`value`: Output<Int>) {
        this.coreCount = value
    }

    /**
     * @param value Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("lhlueuwlyrrscuur")
    public suspend
    fun customProperties(`value`: Output<List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs>>) {
        this.customProperties = value
    }

    @JvmName("dednaekgqaeajvlc")
    public suspend fun customProperties(
        vararg
        values: Output<IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs>,
    ) {
        this.customProperties = Output.all(values.asList())
    }

    /**
     * @param values Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("wycjmytjkptvvmby")
    public suspend
    fun customProperties(values: List<Output<IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs>>) {
        this.customProperties = Output.all(values)
    }

    /**
     * @param value Time to live (in minutes) setting of the cluster which will execute data flow job.
     */
    @JvmName("txsjrcgwdnqhkqxq")
    public suspend fun timeToLive(`value`: Output<Int>) {
        this.timeToLive = value
    }

    /**
     * @param value Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if this is set as false. Default is true.
     */
    @JvmName("xnuhdcqryfpvsqut")
    public suspend fun cleanup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanup = mapped
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("xttogwpmnbucajeb")
    public suspend fun computeType(`value`: Either<String, DataFlowComputeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("vbjefglissrycwig")
    public fun computeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataFlowComputeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("idldclxdvofksvub")
    public fun computeType(`value`: DataFlowComputeType) {
        val toBeMapped = Either.ofRight<String, DataFlowComputeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
     */
    @JvmName("gjfhibmrsignleej")
    public suspend fun coreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreCount = mapped
    }

    /**
     * @param value Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("wmvepauyxodkxiie")
    public suspend
    fun customProperties(`value`: List<IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param argument Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("alhndhydvisavjko")
    public suspend
    fun customProperties(argument: List<suspend IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customProperties = mapped
    }

    /**
     * @param argument Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("llayjtsmujwomjnx")
    public suspend fun customProperties(
        vararg
        argument: suspend IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customProperties = mapped
    }

    /**
     * @param argument Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("kmhklgxfkwqdfwka")
    public suspend
    fun customProperties(argument: suspend IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customProperties = mapped
    }

    /**
     * @param values Custom properties are used to tune the data flow runtime performance.
     */
    @JvmName("jltydancpupkmqth")
    public suspend fun customProperties(
        vararg
        values: IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Time to live (in minutes) setting of the cluster which will execute data flow job.
     */
    @JvmName("njpidumguvlpihnm")
    public suspend fun timeToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    internal fun build(): IntegrationRuntimeDataFlowPropertiesArgs =
        IntegrationRuntimeDataFlowPropertiesArgs(
            cleanup = cleanup,
            computeType = computeType,
            coreCount = coreCount,
            customProperties = customProperties,
            timeToLive = timeToLive,
        )
}
