@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeVNetPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VNet properties for managed integration runtime.
 * @property publicIPs Resource IDs of the public IP addresses that this integration runtime will use.
 * @property subnet The name of the subnet this integration runtime will join.
 * @property subnetId The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
 * @property vNetId The ID of the VNet that this integration runtime will join.
 */
public data class IntegrationRuntimeVNetPropertiesArgs(
    public val publicIPs: Output<List<String>>? = null,
    public val subnet: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val vNetId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeVNetPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeVNetPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeVNetPropertiesArgs.builder()
            .publicIPs(publicIPs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnet(subnet?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .vNetId(vNetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeVNetPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeVNetPropertiesArgsBuilder internal constructor() {
    private var publicIPs: Output<List<String>>? = null

    private var subnet: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var vNetId: Output<String>? = null

    /**
     * @param value Resource IDs of the public IP addresses that this integration runtime will use.
     */
    @JvmName("nlsjqybghcwhurec")
    public suspend fun publicIPs(`value`: Output<List<String>>) {
        this.publicIPs = value
    }

    @JvmName("gsqjqhglyrennqoh")
    public suspend fun publicIPs(vararg values: Output<String>) {
        this.publicIPs = Output.all(values.asList())
    }

    /**
     * @param values Resource IDs of the public IP addresses that this integration runtime will use.
     */
    @JvmName("ggijpgftabpbtplt")
    public suspend fun publicIPs(values: List<Output<String>>) {
        this.publicIPs = Output.all(values)
    }

    /**
     * @param value The name of the subnet this integration runtime will join.
     */
    @JvmName("hgqmidccxlgfwhud")
    public suspend fun subnet(`value`: Output<String>) {
        this.subnet = value
    }

    /**
     * @param value The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
     */
    @JvmName("mtvdyflhotpvnfnl")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the VNet that this integration runtime will join.
     */
    @JvmName("ufjrheuqntryhcmu")
    public suspend fun vNetId(`value`: Output<String>) {
        this.vNetId = value
    }

    /**
     * @param value Resource IDs of the public IP addresses that this integration runtime will use.
     */
    @JvmName("xvujoahxipxhrins")
    public suspend fun publicIPs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPs = mapped
    }

    /**
     * @param values Resource IDs of the public IP addresses that this integration runtime will use.
     */
    @JvmName("bnraoxivopprrosi")
    public suspend fun publicIPs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPs = mapped
    }

    /**
     * @param value The name of the subnet this integration runtime will join.
     */
    @JvmName("ejgaypwwiqrxtdqi")
    public suspend fun subnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param value The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
     */
    @JvmName("gmmisqsqoxthqida")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The ID of the VNet that this integration runtime will join.
     */
    @JvmName("npnnpomuovdfwpoe")
    public suspend fun vNetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vNetId = mapped
    }

    internal fun build(): IntegrationRuntimeVNetPropertiesArgs = IntegrationRuntimeVNetPropertiesArgs(
        publicIPs = publicIPs,
        subnet = subnet,
        subnetId = subnetId,
        vNetId = vNetId,
    )
}
