@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeKeyAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The key authorization type integration runtime.
 * @property authorizationType The authorization type for integration runtime sharing.
 * Expected value is 'Key'.
 * @property key The key used for authorization.
 */
public data class LinkedIntegrationRuntimeKeyAuthorizationArgs(
    public val authorizationType: Output<String>,
    public val key: Output<SecureStringArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeKeyAuthorizationArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeKeyAuthorizationArgs =
        com.pulumi.azurenative.datafactory.inputs.LinkedIntegrationRuntimeKeyAuthorizationArgs.builder()
            .authorizationType(authorizationType.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LinkedIntegrationRuntimeKeyAuthorizationArgs].
 */
@PulumiTagMarker
public class LinkedIntegrationRuntimeKeyAuthorizationArgsBuilder internal constructor() {
    private var authorizationType: Output<String>? = null

    private var key: Output<SecureStringArgs>? = null

    /**
     * @param value The authorization type for integration runtime sharing.
     * Expected value is 'Key'.
     */
    @JvmName("sttyugifvterivbp")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value The key used for authorization.
     */
    @JvmName("psaqgtnamhnbpbjh")
    public suspend fun key(`value`: Output<SecureStringArgs>) {
        this.key = value
    }

    /**
     * @param value The authorization type for integration runtime sharing.
     * Expected value is 'Key'.
     */
    @JvmName("wgccqxsacxwbvblr")
    public suspend fun authorizationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value The key used for authorization.
     */
    @JvmName("dccxrmjiidtvgvjs")
    public suspend fun key(`value`: SecureStringArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param argument The key used for authorization.
     */
    @JvmName("twsjnbdmfojyroqe")
    public suspend fun key(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.key = mapped
    }

    internal fun build(): LinkedIntegrationRuntimeKeyAuthorizationArgs =
        LinkedIntegrationRuntimeKeyAuthorizationArgs(
            authorizationType = authorizationType ?: throw PulumiNullFieldException("authorizationType"),
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
