@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LinkedServiceReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.Type
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service reference type.
 * @property parameters Arguments for LinkedService.
 * @property referenceName Reference LinkedService name.
 * @property type Linked service reference type.
 */
public data class LinkedServiceReferenceArgs(
    public val parameters: Output<Map<String, Any>>? = null,
    public val referenceName: Output<String>,
    public val type: Output<Either<String, Type>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LinkedServiceReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LinkedServiceReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.LinkedServiceReferenceArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LinkedServiceReferenceArgs].
 */
@PulumiTagMarker
public class LinkedServiceReferenceArgsBuilder internal constructor() {
    private var parameters: Output<Map<String, Any>>? = null

    private var referenceName: Output<String>? = null

    private var type: Output<Either<String, Type>>? = null

    /**
     * @param value Arguments for LinkedService.
     */
    @JvmName("erucjmthavbojmyl")
    public suspend fun parameters(`value`: Output<Map<String, Any>>) {
        this.parameters = value
    }

    /**
     * @param value Reference LinkedService name.
     */
    @JvmName("imboaeetytaeioqb")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Linked service reference type.
     */
    @JvmName("boevbtnewmgmskbn")
    public suspend fun type(`value`: Output<Either<String, Type>>) {
        this.type = value
    }

    /**
     * @param value Arguments for LinkedService.
     */
    @JvmName("qjhattukciiqbufh")
    public suspend fun parameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Arguments for LinkedService.
     */
    @JvmName("quyvecwqslbjhxnw")
    public fun parameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Reference LinkedService name.
     */
    @JvmName("dtwonkwmbktxktoe")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Linked service reference type.
     */
    @JvmName("bfdyhspdfvfdtvem")
    public suspend fun type(`value`: Either<String, Type>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Linked service reference type.
     */
    @JvmName("tcrsgsupwcqfmaly")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Linked service reference type.
     */
    @JvmName("lkxkivbhvrsmlkdx")
    public fun type(`value`: Type) {
        val toBeMapped = Either.ofRight<String, Type>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LinkedServiceReferenceArgs = LinkedServiceReferenceArgs(
        parameters = parameters,
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
