@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.LogStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * (Deprecated. Please use LogSettings) Log storage settings.
 * @property enableReliableLogging Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
 * @property linkedServiceName Log storage linked service reference.
 * @property logLevel Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
 * @property path The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
 */
public data class LogStorageSettingsArgs(
    public val enableReliableLogging: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val logLevel: Output<Any>? = null,
    public val path: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.LogStorageSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.LogStorageSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.LogStorageSettingsArgs.builder()
            .enableReliableLogging(enableReliableLogging?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogStorageSettingsArgs].
 */
@PulumiTagMarker
public class LogStorageSettingsArgsBuilder internal constructor() {
    private var enableReliableLogging: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var logLevel: Output<Any>? = null

    private var path: Output<Any>? = null

    /**
     * @param value Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xyygrlhtsdpwdohe")
    public suspend fun enableReliableLogging(`value`: Output<Any>) {
        this.enableReliableLogging = value
    }

    /**
     * @param value Log storage linked service reference.
     */
    @JvmName("uabnivyxvrsxwujw")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
     */
    @JvmName("wuyktljwtxktrlix")
    public suspend fun logLevel(`value`: Output<Any>) {
        this.logLevel = value
    }

    /**
     * @param value The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
     */
    @JvmName("xafavspgbfcqggrv")
    public suspend fun path(`value`: Output<Any>) {
        this.path = value
    }

    /**
     * @param value Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fmsuterfevlxgppn")
    public suspend fun enableReliableLogging(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableReliableLogging = mapped
    }

    /**
     * @param value Log storage linked service reference.
     */
    @JvmName("ucxpdicibqolspld")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Log storage linked service reference.
     */
    @JvmName("dhxrbwxbhafiprko")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
     */
    @JvmName("brxxklerncdsnukp")
    public suspend fun logLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
     */
    @JvmName("kqbaocrunerktryf")
    public suspend fun path(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): LogStorageSettingsArgs = LogStorageSettingsArgs(
        enableReliableLogging = enableReliableLogging,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        logLevel = logLevel,
        path = path,
    )
}
