@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MagentoLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Magento server linked service.
 * @property accessToken The access token from Magento.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'Magento'.
 * @property useEncryptedEndpoints Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
 * @property useHostVerification Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
 * @property usePeerVerification Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
 */
public data class MagentoLinkedServiceArgs(
    public val accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
    public val useEncryptedEndpoints: Output<Any>? = null,
    public val useHostVerification: Output<Any>? = null,
    public val usePeerVerification: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MagentoLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MagentoLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.MagentoLinkedServiceArgs.builder()
            .accessToken(
                accessToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .useEncryptedEndpoints(useEncryptedEndpoints?.applyValue({ args0 -> args0 }))
            .useHostVerification(useHostVerification?.applyValue({ args0 -> args0 }))
            .usePeerVerification(usePeerVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MagentoLinkedServiceArgs].
 */
@PulumiTagMarker
public class MagentoLinkedServiceArgsBuilder internal constructor() {
    private var accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    private var useEncryptedEndpoints: Output<Any>? = null

    private var useHostVerification: Output<Any>? = null

    private var usePeerVerification: Output<Any>? = null

    /**
     * @param value The access token from Magento.
     */
    @JvmName("mmarbvrhsghwxsbp")
    public suspend
    fun accessToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessToken = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("jmxqvhiecrcgdbtb")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("dnjcbrdujrricfda")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("rcjxovxululprqwu")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("usqaksnynmqjafde")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("vreabscyijjfbglv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ettelsbdltyiuoeh")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
     */
    @JvmName("icmisybibmabkfis")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("vomcnemseofovwfp")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Magento'.
     */
    @JvmName("iurhvhcndjfglhhn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("fimycftjcvficirh")
    public suspend fun useEncryptedEndpoints(`value`: Output<Any>) {
        this.useEncryptedEndpoints = value
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("rkquptualbvehfyr")
    public suspend fun useHostVerification(`value`: Output<Any>) {
        this.useHostVerification = value
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("obufvyaobjgqyaug")
    public suspend fun usePeerVerification(`value`: Output<Any>) {
        this.usePeerVerification = value
    }

    /**
     * @param value The access token from Magento.
     */
    @JvmName("qyagdldodkpobali")
    public suspend
    fun accessToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The access token from Magento.
     */
    @JvmName("ccqrqdspjbfsejha")
    public fun accessToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The access token from Magento.
     */
    @JvmName("vguxosbdrpcwvxtf")
    public fun accessToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mvpypfeqmaxgnuql")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("twlskwjekcnnlkyw")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("yememnjslgbkctor")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("qrewjoyapkybpegk")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("lvpnlfvodrtmarrm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("vyhyxsmombevitec")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
     */
    @JvmName("syfxqjfmwahnlyse")
    public suspend fun host(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("xsefiombdjxppvty")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("rewymuouyvjormip")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("hipykalrnfddlyun")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Magento'.
     */
    @JvmName("gscaluhhtuoxfvmk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
     */
    @JvmName("vwsckohkqicuxvfp")
    public suspend fun useEncryptedEndpoints(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEncryptedEndpoints = mapped
    }

    /**
     * @param value Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
     */
    @JvmName("jcyvxuolxccckdvn")
    public suspend fun useHostVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useHostVerification = mapped
    }

    /**
     * @param value Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
     */
    @JvmName("hhrqfwycegvtuidf")
    public suspend fun usePeerVerification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePeerVerification = mapped
    }

    internal fun build(): MagentoLinkedServiceArgs = MagentoLinkedServiceArgs(
        accessToken = accessToken,
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        host = host ?: throw PulumiNullFieldException("host"),
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
        useEncryptedEndpoints = useEncryptedEndpoints,
        useHostVerification = useHostVerification,
        usePeerVerification = usePeerVerification,
    )
}
