@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ManagedIdentityCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed identity credential.
 * @property annotations List of tags that can be used for describing the Credential.
 * @property description Credential description.
 * @property resourceId The resource id of user assigned managed identity
 * @property type Type of credential.
 * Expected value is 'ManagedIdentity'.
 */
public data class ManagedIdentityCredentialArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ManagedIdentityCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ManagedIdentityCredentialArgs =
        com.pulumi.azurenative.datafactory.inputs.ManagedIdentityCredentialArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityCredentialArgs].
 */
@PulumiTagMarker
public class ManagedIdentityCredentialArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Credential.
     */
    @JvmName("wbkflvhfoeauttlk")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("kejgtdoluwvtxbte")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Credential.
     */
    @JvmName("imcuwhhrofxpibjf")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Credential description.
     */
    @JvmName("bgedhvkfaswmeooo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The resource id of user assigned managed identity
     */
    @JvmName("sfguxflbyhatymbm")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Type of credential.
     * Expected value is 'ManagedIdentity'.
     */
    @JvmName("wipcjtyxdqgbngfw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Credential.
     */
    @JvmName("xrklmrkcukqeysvi")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Credential.
     */
    @JvmName("wrugotrgsceskkgp")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Credential description.
     */
    @JvmName("suakjnmqbqfipwxf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The resource id of user assigned managed identity
     */
    @JvmName("xqvejaqbnwtgnopu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Type of credential.
     * Expected value is 'ManagedIdentity'.
     */
    @JvmName("clrxkypujaafsris")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedIdentityCredentialArgs = ManagedIdentityCredentialArgs(
        annotations = annotations,
        description = description,
        resourceId = resourceId,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
