@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ManagedVirtualNetworkReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ManagedVirtualNetworkReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed Virtual Network reference type.
 * @property referenceName Reference ManagedVirtualNetwork name.
 * @property type Managed Virtual Network reference type.
 */
public data class ManagedVirtualNetworkReferenceArgs(
    public val referenceName: Output<String>,
    public val type: Output<Either<String, ManagedVirtualNetworkReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ManagedVirtualNetworkReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.ManagedVirtualNetworkReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.ManagedVirtualNetworkReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedVirtualNetworkReferenceArgs].
 */
@PulumiTagMarker
public class ManagedVirtualNetworkReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<String>? = null

    private var type: Output<Either<String, ManagedVirtualNetworkReferenceType>>? = null

    /**
     * @param value Reference ManagedVirtualNetwork name.
     */
    @JvmName("cpgfdsxqjopawiwh")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Managed Virtual Network reference type.
     */
    @JvmName("ekrlviytkxhcganx")
    public suspend fun type(`value`: Output<Either<String, ManagedVirtualNetworkReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference ManagedVirtualNetwork name.
     */
    @JvmName("hhsmdkagxggxoxxy")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Managed Virtual Network reference type.
     */
    @JvmName("ijysttfwemjgedgm")
    public suspend fun type(`value`: Either<String, ManagedVirtualNetworkReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed Virtual Network reference type.
     */
    @JvmName("mwueecdqfbttlisi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedVirtualNetworkReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed Virtual Network reference type.
     */
    @JvmName("krqtkerjvujcafsn")
    public fun type(`value`: ManagedVirtualNetworkReferenceType) {
        val toBeMapped = Either.ofRight<String, ManagedVirtualNetworkReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedVirtualNetworkReferenceArgs = ManagedVirtualNetworkReferenceArgs(
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
