@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Attribute mapping details.
 * @property attributeMappings List of attribute mappings.
 */
public data class MapperAttributeMappingsArgs(
    public val attributeMappings: Output<List<MapperAttributeMappingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingsArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingsArgs.builder()
            .attributeMappings(
                attributeMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperAttributeMappingsArgs].
 */
@PulumiTagMarker
public class MapperAttributeMappingsArgsBuilder internal constructor() {
    private var attributeMappings: Output<List<MapperAttributeMappingArgs>>? = null

    /**
     * @param value List of attribute mappings.
     */
    @JvmName("ccebspiayxaqhxpk")
    public suspend fun attributeMappings(`value`: Output<List<MapperAttributeMappingArgs>>) {
        this.attributeMappings = value
    }

    @JvmName("jjykjcowklrwyiss")
    public suspend fun attributeMappings(vararg values: Output<MapperAttributeMappingArgs>) {
        this.attributeMappings = Output.all(values.asList())
    }

    /**
     * @param values List of attribute mappings.
     */
    @JvmName("vsubuusihecvicbs")
    public suspend fun attributeMappings(values: List<Output<MapperAttributeMappingArgs>>) {
        this.attributeMappings = Output.all(values)
    }

    /**
     * @param value List of attribute mappings.
     */
    @JvmName("ydqobrjjktjsbfvm")
    public suspend fun attributeMappings(`value`: List<MapperAttributeMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeMappings = mapped
    }

    /**
     * @param argument List of attribute mappings.
     */
    @JvmName("mubamhtsygpfnskv")
    public suspend
    fun attributeMappings(argument: List<suspend MapperAttributeMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperAttributeMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attributeMappings = mapped
    }

    /**
     * @param argument List of attribute mappings.
     */
    @JvmName("oiitmlmvhevadicw")
    public suspend fun attributeMappings(
        vararg
        argument: suspend MapperAttributeMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MapperAttributeMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attributeMappings = mapped
    }

    /**
     * @param argument List of attribute mappings.
     */
    @JvmName("yvbxlkqfluadcoqo")
    public suspend
    fun attributeMappings(argument: suspend MapperAttributeMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MapperAttributeMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.attributeMappings = mapped
    }

    /**
     * @param values List of attribute mappings.
     */
    @JvmName("hmeudhqbfynkjeps")
    public suspend fun attributeMappings(vararg values: MapperAttributeMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeMappings = mapped
    }

    internal fun build(): MapperAttributeMappingsArgs = MapperAttributeMappingsArgs(
        attributeMappings = attributeMappings,
    )
}
