@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperSourceConnectionsInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A object which contains list of tables and connection details for a source connection.
 * @property connection Source connection details.
 * @property sourceEntities List of source tables for a source connection.
 */
public data class MapperSourceConnectionsInfoArgs(
    public val connection: Output<MapperConnectionArgs>? = null,
    public val sourceEntities: Output<List<MapperTableArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperSourceConnectionsInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperSourceConnectionsInfoArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperSourceConnectionsInfoArgs.builder()
            .connection(connection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceEntities(
                sourceEntities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperSourceConnectionsInfoArgs].
 */
@PulumiTagMarker
public class MapperSourceConnectionsInfoArgsBuilder internal constructor() {
    private var connection: Output<MapperConnectionArgs>? = null

    private var sourceEntities: Output<List<MapperTableArgs>>? = null

    /**
     * @param value Source connection details.
     */
    @JvmName("jurcmwnowggfuovq")
    public suspend fun connection(`value`: Output<MapperConnectionArgs>) {
        this.connection = value
    }

    /**
     * @param value List of source tables for a source connection.
     */
    @JvmName("qrmjxqxhhsprqonf")
    public suspend fun sourceEntities(`value`: Output<List<MapperTableArgs>>) {
        this.sourceEntities = value
    }

    @JvmName("qvccppbrfpgapapj")
    public suspend fun sourceEntities(vararg values: Output<MapperTableArgs>) {
        this.sourceEntities = Output.all(values.asList())
    }

    /**
     * @param values List of source tables for a source connection.
     */
    @JvmName("cdewttmlgeujdded")
    public suspend fun sourceEntities(values: List<Output<MapperTableArgs>>) {
        this.sourceEntities = Output.all(values)
    }

    /**
     * @param value Source connection details.
     */
    @JvmName("hbhoocjkkhypedwc")
    public suspend fun connection(`value`: MapperConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connection = mapped
    }

    /**
     * @param argument Source connection details.
     */
    @JvmName("fpphxqwrhulcoloe")
    public suspend fun connection(argument: suspend MapperConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = MapperConnectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connection = mapped
    }

    /**
     * @param value List of source tables for a source connection.
     */
    @JvmName("klvvjsitrihruvjd")
    public suspend fun sourceEntities(`value`: List<MapperTableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntities = mapped
    }

    /**
     * @param argument List of source tables for a source connection.
     */
    @JvmName("bpchftfbespvmohx")
    public suspend fun sourceEntities(argument: List<suspend MapperTableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MapperTableArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceEntities = mapped
    }

    /**
     * @param argument List of source tables for a source connection.
     */
    @JvmName("elbgdgsuwxkdumgg")
    public suspend fun sourceEntities(vararg argument: suspend MapperTableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MapperTableArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceEntities = mapped
    }

    /**
     * @param argument List of source tables for a source connection.
     */
    @JvmName("uyuprfqvgxvnelqe")
    public suspend fun sourceEntities(argument: suspend MapperTableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MapperTableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceEntities = mapped
    }

    /**
     * @param values List of source tables for a source connection.
     */
    @JvmName("nplucscaiqrupvar")
    public suspend fun sourceEntities(vararg values: MapperTableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceEntities = mapped
    }

    internal fun build(): MapperSourceConnectionsInfoArgs = MapperSourceConnectionsInfoArgs(
        connection = connection,
        sourceEntities = sourceEntities,
    )
}
