@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MariaDBLinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MariaDB server linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property database Database name for connection. Type: string.
 * @property description Linked service description.
 * @property driverVersion The version of the MariaDB driver. Type: string. V1 or empty for legacy driver, V2 for new driver. V1 can support connection string and property bag, V2 can only support connection string.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string.
 * @property port The port for the connection. Type: integer.
 * @property server Server name for connection. Type: string.
 * @property type Type of linked service.
 * Expected value is 'MariaDB'.
 * @property username Username for authentication. Type: string.
 */
public data class MariaDBLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val database: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val driverVersion: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val port: Output<Any>? = null,
    public val server: Output<Any>? = null,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MariaDBLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MariaDBLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.MariaDBLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .driverVersion(driverVersion?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(password?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MariaDBLinkedServiceArgs].
 */
@PulumiTagMarker
public class MariaDBLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var driverVersion: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var port: Output<Any>? = null

    private var server: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mlumemqqochbbwga")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("bhbfiyvfvuiqrxcd")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("oadhefnqvpaoewwu")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("oofjqovrddrqkamo")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("sykoqmbyegankwak")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Database name for connection. Type: string.
     */
    @JvmName("adoqkkhublyhjfht")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ycembogjqlgyqrtr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The version of the MariaDB driver. Type: string. V1 or empty for legacy driver, V2 for new driver. V1 can support connection string and property bag, V2 can only support connection string.
     */
    @JvmName("kdvfdwsokpttpgey")
    public suspend fun driverVersion(`value`: Output<Any>) {
        this.driverVersion = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("pyqwbwklbrkdypce")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("vdfbwiwnoqcuxfrm")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("bviumhvjnuxhfbvu")
    public suspend fun password(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.password = value
    }

    /**
     * @param value The port for the connection. Type: integer.
     */
    @JvmName("ebiaxxlbjbdeqdfd")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value Server name for connection. Type: string.
     */
    @JvmName("rjtpfeliowttvmmi")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'MariaDB'.
     */
    @JvmName("gqjannorcqoybmjt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username for authentication. Type: string.
     */
    @JvmName("wwcwsltlmqtoijxy")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("aeegyfrepqkysxch")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("jhvitrwxiyawaxvf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wrpjnadhnnaybjcn")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("jtoigtewppkraxrc")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("wydswhornmlpxblb")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Database name for connection. Type: string.
     */
    @JvmName("rudphlybyolnaucw")
    public suspend fun database(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("enhxftilmjguysmi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The version of the MariaDB driver. Type: string. V1 or empty for legacy driver, V2 for new driver. V1 can support connection string and property bag, V2 can only support connection string.
     */
    @JvmName("ahglbicxrsbkglvf")
    public suspend fun driverVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driverVersion = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("jqakhhwnilaeopss")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("qmgtuksiroedtiom")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("gbroqulrrsryqkrd")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("celfpdvenjplmovc")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("nohrslfcbaplopft")
    public suspend fun password(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of password in connection string.
     */
    @JvmName("pfmxmayhxmikkwbd")
    public suspend
    fun password(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value The port for the connection. Type: integer.
     */
    @JvmName("vrkpnqfvowhykswg")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Server name for connection. Type: string.
     */
    @JvmName("dfhgvqgfntiencfm")
    public suspend fun server(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'MariaDB'.
     */
    @JvmName("mvhkdihgynpsrkua")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username for authentication. Type: string.
     */
    @JvmName("caivvygvpikcoijk")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): MariaDBLinkedServiceArgs = MariaDBLinkedServiceArgs(
        annotations = annotations,
        connectVia = connectVia,
        connectionString = connectionString,
        database = database,
        description = description,
        driverVersion = driverVersion,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        port = port,
        server = server,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
