@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MetadataItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specify the name and value of custom metadata item.
 * @property name Metadata item key name. Type: string (or Expression with resultType string).
 * @property value Metadata item value. Type: string (or Expression with resultType string).
 */
public data class MetadataItemArgs(
    public val name: Output<Any>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MetadataItemArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MetadataItemArgs =
        com.pulumi.azurenative.datafactory.inputs.MetadataItemArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetadataItemArgs].
 */
@PulumiTagMarker
public class MetadataItemArgsBuilder internal constructor() {
    private var name: Output<Any>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Metadata item key name. Type: string (or Expression with resultType string).
     */
    @JvmName("uuikyqtttnmmsgmi")
    public suspend fun name(`value`: Output<Any>) {
        this.name = value
    }

    /**
     * @param value Metadata item value. Type: string (or Expression with resultType string).
     */
    @JvmName("ctfxfpwjqymlfjem")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Metadata item key name. Type: string (or Expression with resultType string).
     */
    @JvmName("pcjxrefwpehotxaa")
    public suspend fun name(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Metadata item value. Type: string (or Expression with resultType string).
     */
    @JvmName("jxdvsptvonrsqlwl")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): MetadataItemArgs = MetadataItemArgs(
        name = name,
        `value` = `value`,
    )
}
