@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.OraclePartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for Oracle source partitioning.
 * @property partitionColumnName The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionNames Names of the physical partitions of Oracle table.
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class OraclePartitionSettingsArgs(
    public val partitionColumnName: Output<Any>? = null,
    public val partitionLowerBound: Output<Any>? = null,
    public val partitionNames: Output<List<Any>>? = null,
    public val partitionUpperBound: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.OraclePartitionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.OraclePartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.OraclePartitionSettingsArgs.builder()
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 }))
            .partitionLowerBound(partitionLowerBound?.applyValue({ args0 -> args0 }))
            .partitionNames(partitionNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .partitionUpperBound(partitionUpperBound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OraclePartitionSettingsArgs].
 */
@PulumiTagMarker
public class OraclePartitionSettingsArgsBuilder internal constructor() {
    private var partitionColumnName: Output<Any>? = null

    private var partitionLowerBound: Output<Any>? = null

    private var partitionNames: Output<List<Any>>? = null

    private var partitionUpperBound: Output<Any>? = null

    /**
     * @param value The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("mkfkmldnosjqpkqj")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("jjepvajjobpxqlep")
    public suspend fun partitionLowerBound(`value`: Output<Any>) {
        this.partitionLowerBound = value
    }

    /**
     * @param value Names of the physical partitions of Oracle table.
     */
    @JvmName("wbhehewynothifuu")
    public suspend fun partitionNames(`value`: Output<List<Any>>) {
        this.partitionNames = value
    }

    @JvmName("veylotbqijpimbfo")
    public suspend fun partitionNames(vararg values: Output<Any>) {
        this.partitionNames = Output.all(values.asList())
    }

    /**
     * @param values Names of the physical partitions of Oracle table.
     */
    @JvmName("dycpsurxjyjnhkxj")
    public suspend fun partitionNames(values: List<Output<Any>>) {
        this.partitionNames = Output.all(values)
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("flqhwqkvpfprsdau")
    public suspend fun partitionUpperBound(`value`: Output<Any>) {
        this.partitionUpperBound = value
    }

    /**
     * @param value The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("mksjsvukicpsahqn")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("wtuwtdbmlmnhwewr")
    public suspend fun partitionLowerBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionLowerBound = mapped
    }

    /**
     * @param value Names of the physical partitions of Oracle table.
     */
    @JvmName("bujxicsfqspeonrn")
    public suspend fun partitionNames(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionNames = mapped
    }

    /**
     * @param values Names of the physical partitions of Oracle table.
     */
    @JvmName("ryfwlynvhmfnlrks")
    public suspend fun partitionNames(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionNames = mapped
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("vpuwjcplnhxtbuss")
    public suspend fun partitionUpperBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionUpperBound = mapped
    }

    internal fun build(): OraclePartitionSettingsArgs = OraclePartitionSettingsArgs(
        partitionColumnName = partitionColumnName,
        partitionLowerBound = partitionLowerBound,
        partitionNames = partitionNames,
        partitionUpperBound = partitionUpperBound,
    )
}
