@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.OrcWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Orc write settings.
 * @property fileNamePrefix Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
 * @property maxRowsPerFile Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
 * @property type The write setting type.
 * Expected value is 'OrcWriteSettings'.
 */
public data class OrcWriteSettingsArgs(
    public val fileNamePrefix: Output<Any>? = null,
    public val maxRowsPerFile: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.OrcWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.OrcWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.OrcWriteSettingsArgs.builder()
            .fileNamePrefix(fileNamePrefix?.applyValue({ args0 -> args0 }))
            .maxRowsPerFile(maxRowsPerFile?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrcWriteSettingsArgs].
 */
@PulumiTagMarker
public class OrcWriteSettingsArgsBuilder internal constructor() {
    private var fileNamePrefix: Output<Any>? = null

    private var maxRowsPerFile: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JvmName("pfjuoafbiyosvvpf")
    public suspend fun fileNamePrefix(`value`: Output<Any>) {
        this.fileNamePrefix = value
    }

    /**
     * @param value Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("quvmbubbtyafipfy")
    public suspend fun maxRowsPerFile(`value`: Output<Any>) {
        this.maxRowsPerFile = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'OrcWriteSettings'.
     */
    @JvmName("kxdinmfbvhhncivr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the file name pattern <fileNamePrefix>_<fileIndex>.<fileExtension> when copy from non-file based store without partitionOptions. Type: string (or Expression with resultType string).
     */
    @JvmName("eixexdxulamfnplb")
    public suspend fun fileNamePrefix(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileNamePrefix = mapped
    }

    /**
     * @param value Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("bbgwclikblktqpet")
    public suspend fun maxRowsPerFile(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRowsPerFile = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'OrcWriteSettings'.
     */
    @JvmName("fcxorrkfmyddendo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OrcWriteSettingsArgs = OrcWriteSettingsArgs(
        fileNamePrefix = fileNamePrefix,
        maxRowsPerFile = maxRowsPerFile,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
