@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.PowerQuerySourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Power query source.
 * @property dataset Dataset reference.
 * @property description Transformation description.
 * @property flowlet Flowlet Reference
 * @property linkedService Linked service reference.
 * @property name Transformation name.
 * @property schemaLinkedService Schema linked service reference.
 * @property script source script.
 */
public data class PowerQuerySourceArgs(
    public val dataset: Output<DatasetReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val flowlet: Output<DataFlowReferenceArgs>? = null,
    public val linkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val schemaLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val script: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.PowerQuerySourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.PowerQuerySourceArgs =
        com.pulumi.azurenative.datafactory.inputs.PowerQuerySourceArgs.builder()
            .dataset(dataset?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowlet(flowlet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedService(linkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .schemaLinkedService(
                schemaLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .script(script?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PowerQuerySourceArgs].
 */
@PulumiTagMarker
public class PowerQuerySourceArgsBuilder internal constructor() {
    private var dataset: Output<DatasetReferenceArgs>? = null

    private var description: Output<String>? = null

    private var flowlet: Output<DataFlowReferenceArgs>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var schemaLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var script: Output<String>? = null

    /**
     * @param value Dataset reference.
     */
    @JvmName("tgbojndnymdfnvay")
    public suspend fun dataset(`value`: Output<DatasetReferenceArgs>) {
        this.dataset = value
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("cpoilvhmtjnxyuqi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("ehtpcbsftmxjgkof")
    public suspend fun flowlet(`value`: Output<DataFlowReferenceArgs>) {
        this.flowlet = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("latwfxmkmbiunobu")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("jgiavfbemmqlwpls")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Schema linked service reference.
     */
    @JvmName("qkoatydnhwqplcpi")
    public suspend fun schemaLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.schemaLinkedService = value
    }

    /**
     * @param value source script.
     */
    @JvmName("ehjifvpyuqnnsiol")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Dataset reference.
     */
    @JvmName("cwfbtwbmcmbudxov")
    public suspend fun dataset(`value`: DatasetReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param argument Dataset reference.
     */
    @JvmName("hpbdanyatgctqaol")
    public suspend fun dataset(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataset = mapped
    }

    /**
     * @param value Transformation description.
     */
    @JvmName("tfohddgdsyyagmaj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Flowlet Reference
     */
    @JvmName("jfqogynljcgdjgno")
    public suspend fun flowlet(`value`: DataFlowReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowlet = mapped
    }

    /**
     * @param argument Flowlet Reference
     */
    @JvmName("fmaysylyssixcuqu")
    public suspend fun flowlet(argument: suspend DataFlowReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.flowlet = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("jnokyhhpmihufgql")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("jloeqhrnlcqaygxk")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    /**
     * @param value Transformation name.
     */
    @JvmName("kesudvgdqcmkgcac")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Schema linked service reference.
     */
    @JvmName("eyaffjvyrcmxbqof")
    public suspend fun schemaLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaLinkedService = mapped
    }

    /**
     * @param argument Schema linked service reference.
     */
    @JvmName("jhlmgqbbflfdyqpk")
    public suspend
    fun schemaLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schemaLinkedService = mapped
    }

    /**
     * @param value source script.
     */
    @JvmName("hfkybrtvibxvqxyo")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    internal fun build(): PowerQuerySourceArgs = PowerQuerySourceArgs(
        dataset = dataset,
        description = description,
        flowlet = flowlet,
        linkedService = linkedService,
        name = name ?: throw PulumiNullFieldException("name"),
        schemaLinkedService = schemaLinkedService,
        script = script,
    )
}
