@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISChildPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSIS embedded child package.
 * @property packageContent Content for embedded child package. Type: string (or Expression with resultType string).
 * @property packageLastModifiedDate Last modified date for embedded child package.
 * @property packageName Name for embedded child package.
 * @property packagePath Path for embedded child package. Type: string (or Expression with resultType string).
 */
public data class SSISChildPackageArgs(
    public val packageContent: Output<Any>,
    public val packageLastModifiedDate: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val packagePath: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISChildPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISChildPackageArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISChildPackageArgs.builder()
            .packageContent(packageContent.applyValue({ args0 -> args0 }))
            .packageLastModifiedDate(packageLastModifiedDate?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .packagePath(packagePath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SSISChildPackageArgs].
 */
@PulumiTagMarker
public class SSISChildPackageArgsBuilder internal constructor() {
    private var packageContent: Output<Any>? = null

    private var packageLastModifiedDate: Output<String>? = null

    private var packageName: Output<String>? = null

    private var packagePath: Output<Any>? = null

    /**
     * @param value Content for embedded child package. Type: string (or Expression with resultType string).
     */
    @JvmName("hmwbslolvtebfibx")
    public suspend fun packageContent(`value`: Output<Any>) {
        this.packageContent = value
    }

    /**
     * @param value Last modified date for embedded child package.
     */
    @JvmName("hbuwljpbttqkjguu")
    public suspend fun packageLastModifiedDate(`value`: Output<String>) {
        this.packageLastModifiedDate = value
    }

    /**
     * @param value Name for embedded child package.
     */
    @JvmName("dpbmlxsxwajmcgry")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Path for embedded child package. Type: string (or Expression with resultType string).
     */
    @JvmName("isvarsguafndjkcq")
    public suspend fun packagePath(`value`: Output<Any>) {
        this.packagePath = value
    }

    /**
     * @param value Content for embedded child package. Type: string (or Expression with resultType string).
     */
    @JvmName("dlfmcdiprfdoxtnw")
    public suspend fun packageContent(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageContent = mapped
    }

    /**
     * @param value Last modified date for embedded child package.
     */
    @JvmName("erpkvkamexplesph")
    public suspend fun packageLastModifiedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageLastModifiedDate = mapped
    }

    /**
     * @param value Name for embedded child package.
     */
    @JvmName("utybiunohtankxwh")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Path for embedded child package. Type: string (or Expression with resultType string).
     */
    @JvmName("melvgytpakpoogob")
    public suspend fun packagePath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packagePath = mapped
    }

    internal fun build(): SSISChildPackageArgs = SSISChildPackageArgs(
        packageContent = packageContent ?: throw PulumiNullFieldException("packageContent"),
        packageLastModifiedDate = packageLastModifiedDate,
        packageName = packageName,
        packagePath = packagePath ?: throw PulumiNullFieldException("packagePath"),
    )
}
