@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISExecutionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSIS execution parameter.
 * @property value SSIS package execution parameter value. Type: string (or Expression with resultType string).
 */
public data class SSISExecutionParameterArgs(
    public val `value`: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISExecutionParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISExecutionParameterArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISExecutionParameterArgs.builder()
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SSISExecutionParameterArgs].
 */
@PulumiTagMarker
public class SSISExecutionParameterArgsBuilder internal constructor() {
    private var `value`: Output<Any>? = null

    /**
     * @param value SSIS package execution parameter value. Type: string (or Expression with resultType string).
     */
    @JvmName("ufvgufjmdjsvyyts")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value SSIS package execution parameter value. Type: string (or Expression with resultType string).
     */
    @JvmName("ipjmivmkvmeskpyq")
    public suspend fun `value`(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SSISExecutionParameterArgs = SSISExecutionParameterArgs(
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
