@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SSISPackageLocationArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SsisPackageLocationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSIS package location.
 * @property accessCredential The package access credential.
 * @property childPackages The embedded child package list.
 * @property configurationAccessCredential The configuration file access credential.
 * @property configurationPath The configuration file of the package execution. Type: string (or Expression with resultType string).
 * @property packageContent The embedded package content. Type: string (or Expression with resultType string).
 * @property packageLastModifiedDate The embedded package last modified date.
 * @property packageName The package name.
 * @property packagePassword Password of the package.
 * @property packagePath The SSIS package path. Type: string (or Expression with resultType string).
 * @property type The type of SSIS package location.
 */
public data class SSISPackageLocationArgs(
    public val accessCredential: Output<SSISAccessCredentialArgs>? = null,
    public val childPackages: Output<List<SSISChildPackageArgs>>? = null,
    public val configurationAccessCredential: Output<SSISAccessCredentialArgs>? = null,
    public val configurationPath: Output<Any>? = null,
    public val packageContent: Output<Any>? = null,
    public val packageLastModifiedDate: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val packagePassword: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val packagePath: Output<Any>? = null,
    public val type: Output<Either<String, SsisPackageLocationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SSISPackageLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SSISPackageLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.SSISPackageLocationArgs.builder()
            .accessCredential(accessCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .childPackages(
                childPackages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurationAccessCredential(
                configurationAccessCredential?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .configurationPath(configurationPath?.applyValue({ args0 -> args0 }))
            .packageContent(packageContent?.applyValue({ args0 -> args0 }))
            .packageLastModifiedDate(packageLastModifiedDate?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .packagePassword(
                packagePassword?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .packagePath(packagePath?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SSISPackageLocationArgs].
 */
@PulumiTagMarker
public class SSISPackageLocationArgsBuilder internal constructor() {
    private var accessCredential: Output<SSISAccessCredentialArgs>? = null

    private var childPackages: Output<List<SSISChildPackageArgs>>? = null

    private var configurationAccessCredential: Output<SSISAccessCredentialArgs>? = null

    private var configurationPath: Output<Any>? = null

    private var packageContent: Output<Any>? = null

    private var packageLastModifiedDate: Output<String>? = null

    private var packageName: Output<String>? = null

    private var packagePassword: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var packagePath: Output<Any>? = null

    private var type: Output<Either<String, SsisPackageLocationType>>? = null

    /**
     * @param value The package access credential.
     */
    @JvmName("ialhnnlpimhvnmrv")
    public suspend fun accessCredential(`value`: Output<SSISAccessCredentialArgs>) {
        this.accessCredential = value
    }

    /**
     * @param value The embedded child package list.
     */
    @JvmName("sqhwqhxhgnrbgwku")
    public suspend fun childPackages(`value`: Output<List<SSISChildPackageArgs>>) {
        this.childPackages = value
    }

    @JvmName("xsvqcsvtiqnkvpat")
    public suspend fun childPackages(vararg values: Output<SSISChildPackageArgs>) {
        this.childPackages = Output.all(values.asList())
    }

    /**
     * @param values The embedded child package list.
     */
    @JvmName("huthjxtmqedbcfge")
    public suspend fun childPackages(values: List<Output<SSISChildPackageArgs>>) {
        this.childPackages = Output.all(values)
    }

    /**
     * @param value The configuration file access credential.
     */
    @JvmName("glijxylikuikcruo")
    public suspend fun configurationAccessCredential(`value`: Output<SSISAccessCredentialArgs>) {
        this.configurationAccessCredential = value
    }

    /**
     * @param value The configuration file of the package execution. Type: string (or Expression with resultType string).
     */
    @JvmName("jjtuoltmgooecamn")
    public suspend fun configurationPath(`value`: Output<Any>) {
        this.configurationPath = value
    }

    /**
     * @param value The embedded package content. Type: string (or Expression with resultType string).
     */
    @JvmName("acewqccmtumhgxot")
    public suspend fun packageContent(`value`: Output<Any>) {
        this.packageContent = value
    }

    /**
     * @param value The embedded package last modified date.
     */
    @JvmName("qsrebqkajlantmbf")
    public suspend fun packageLastModifiedDate(`value`: Output<String>) {
        this.packageLastModifiedDate = value
    }

    /**
     * @param value The package name.
     */
    @JvmName("hqmvmgbjagawjllb")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Password of the package.
     */
    @JvmName("ittlrhswucxogwnq")
    public suspend
    fun packagePassword(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.packagePassword = value
    }

    /**
     * @param value The SSIS package path. Type: string (or Expression with resultType string).
     */
    @JvmName("vayufjcxdhrjqtcs")
    public suspend fun packagePath(`value`: Output<Any>) {
        this.packagePath = value
    }

    /**
     * @param value The type of SSIS package location.
     */
    @JvmName("aqxrwomxldvpavja")
    public suspend fun type(`value`: Output<Either<String, SsisPackageLocationType>>) {
        this.type = value
    }

    /**
     * @param value The package access credential.
     */
    @JvmName("oyawdirdgjakahuu")
    public suspend fun accessCredential(`value`: SSISAccessCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessCredential = mapped
    }

    /**
     * @param argument The package access credential.
     */
    @JvmName("tflkhjfysuajcnij")
    public suspend
    fun accessCredential(argument: suspend SSISAccessCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = SSISAccessCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessCredential = mapped
    }

    /**
     * @param value The embedded child package list.
     */
    @JvmName("eldjnbhriiybiego")
    public suspend fun childPackages(`value`: List<SSISChildPackageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childPackages = mapped
    }

    /**
     * @param argument The embedded child package list.
     */
    @JvmName("wydigcvcxkwvcune")
    public suspend fun childPackages(argument: List<suspend SSISChildPackageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SSISChildPackageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.childPackages = mapped
    }

    /**
     * @param argument The embedded child package list.
     */
    @JvmName("srdhvrpciqurvthl")
    public suspend fun childPackages(
        vararg
        argument: suspend SSISChildPackageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SSISChildPackageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.childPackages = mapped
    }

    /**
     * @param argument The embedded child package list.
     */
    @JvmName("symxxedrhmllsqwp")
    public suspend fun childPackages(argument: suspend SSISChildPackageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SSISChildPackageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.childPackages = mapped
    }

    /**
     * @param values The embedded child package list.
     */
    @JvmName("nbmqxboqtjbkiwir")
    public suspend fun childPackages(vararg values: SSISChildPackageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.childPackages = mapped
    }

    /**
     * @param value The configuration file access credential.
     */
    @JvmName("bghoaxlsvfbhdfdo")
    public suspend fun configurationAccessCredential(`value`: SSISAccessCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationAccessCredential = mapped
    }

    /**
     * @param argument The configuration file access credential.
     */
    @JvmName("hkplmxjbjteextsn")
    public suspend
    fun configurationAccessCredential(argument: suspend SSISAccessCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = SSISAccessCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configurationAccessCredential = mapped
    }

    /**
     * @param value The configuration file of the package execution. Type: string (or Expression with resultType string).
     */
    @JvmName("cgqvsnqfkqycayqw")
    public suspend fun configurationPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationPath = mapped
    }

    /**
     * @param value The embedded package content. Type: string (or Expression with resultType string).
     */
    @JvmName("dyqajpgcvhlrwemr")
    public suspend fun packageContent(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageContent = mapped
    }

    /**
     * @param value The embedded package last modified date.
     */
    @JvmName("kiiqbyyleiiddcvv")
    public suspend fun packageLastModifiedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageLastModifiedDate = mapped
    }

    /**
     * @param value The package name.
     */
    @JvmName("ilevkotqnhqjufjf")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Password of the package.
     */
    @JvmName("wxspgrqjiseatuer")
    public suspend
    fun packagePassword(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packagePassword = mapped
    }

    /**
     * @param value Password of the package.
     */
    @JvmName("vrekgbpaovkyursq")
    public fun packagePassword(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packagePassword = mapped
    }

    /**
     * @param value Password of the package.
     */
    @JvmName("yubjfsehdrxnkiqu")
    public fun packagePassword(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packagePassword = mapped
    }

    /**
     * @param value The SSIS package path. Type: string (or Expression with resultType string).
     */
    @JvmName("arvtiovfuxgqjast")
    public suspend fun packagePath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packagePath = mapped
    }

    /**
     * @param value The type of SSIS package location.
     */
    @JvmName("clqtmgnmxrwaffcw")
    public suspend fun type(`value`: Either<String, SsisPackageLocationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of SSIS package location.
     */
    @JvmName("smjyfykhwwaoomeq")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SsisPackageLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of SSIS package location.
     */
    @JvmName("rnpqqspdxnalgqgc")
    public fun type(`value`: SsisPackageLocationType) {
        val toBeMapped = Either.ofRight<String, SsisPackageLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SSISPackageLocationArgs = SSISPackageLocationArgs(
        accessCredential = accessCredential,
        childPackages = childPackages,
        configurationAccessCredential = configurationAccessCredential,
        configurationPath = configurationPath,
        packageContent = packageContent,
        packageLastModifiedDate = packageLastModifiedDate,
        packageName = packageName,
        packagePassword = packagePassword,
        packagePath = packagePath,
        type = type,
    )
}
