@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SalesforceV2LinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Salesforce V2.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property apiVersion The Salesforce API version used in ADF. The version must be larger than or equal to 47.0 which is required by Salesforce BULK API 2.0. Type: string (or Expression with resultType string).
 * @property authenticationType The authentication type to be used to connect to the Salesforce. Currently, we only support OAuth2ClientCredentials, it is also the default value
 * @property clientId The client Id for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property environmentUrl The URL of Salesforce instance. For example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'SalesforceV2'.
 */
public data class SalesforceV2LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val apiVersion: Output<Any>? = null,
    public val authenticationType: Output<Any>? = null,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val environmentUrl: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SalesforceV2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SalesforceV2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SalesforceV2LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .environmentUrl(environmentUrl?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SalesforceV2LinkedServiceArgs].
 */
@PulumiTagMarker
public class SalesforceV2LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var apiVersion: Output<Any>? = null

    private var authenticationType: Output<Any>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var environmentUrl: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mjodlqgesbicxrnd")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ibpuvmtgedkywhcb")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hfysvvsnaileehml")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The Salesforce API version used in ADF. The version must be larger than or equal to 47.0 which is required by Salesforce BULK API 2.0. Type: string (or Expression with resultType string).
     */
    @JvmName("burvyexpfirmqjni")
    public suspend fun apiVersion(`value`: Output<Any>) {
        this.apiVersion = value
    }

    /**
     * @param value The authentication type to be used to connect to the Salesforce. Currently, we only support OAuth2ClientCredentials, it is also the default value
     */
    @JvmName("eyusxifuoytdescw")
    public suspend fun authenticationType(`value`: Output<Any>) {
        this.authenticationType = value
    }

    /**
     * @param value The client Id for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance. Type: string (or Expression with resultType string).
     */
    @JvmName("brdftfqhdmpwmetl")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance.
     */
    @JvmName("qtuojtcsoclmsyaq")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("jykuvkgjyyjcwbfe")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("kirdatvgocipefgg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("cfqicdkhnmexmomw")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The URL of Salesforce instance. For example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
     */
    @JvmName("txgywltaeswfksbk")
    public suspend fun environmentUrl(`value`: Output<Any>) {
        this.environmentUrl = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("lyyfgewmnjkkadhe")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SalesforceV2'.
     */
    @JvmName("lkqdorirtsqlkfxa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("obvjawkoktkkyqhb")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("keqyfddtyxirjyoi")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The Salesforce API version used in ADF. The version must be larger than or equal to 47.0 which is required by Salesforce BULK API 2.0. Type: string (or Expression with resultType string).
     */
    @JvmName("ubbubircowtaxkhs")
    public suspend fun apiVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value The authentication type to be used to connect to the Salesforce. Currently, we only support OAuth2ClientCredentials, it is also the default value
     */
    @JvmName("umqulwvydmqbsuln")
    public suspend fun authenticationType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The client Id for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance. Type: string (or Expression with resultType string).
     */
    @JvmName("ejcjnerfpfsssmbi")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance.
     */
    @JvmName("owtjhnnrqdbqdnnr")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance.
     */
    @JvmName("tlismlaplorvtafc")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance.
     */
    @JvmName("ggcjthyinpiqafag")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mreaustoqsmhuljb")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("mdfncysxuvgdtbdy")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("oohpukudbdavfyua")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("yfxpofrgbeqaynwj")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The URL of Salesforce instance. For example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
     */
    @JvmName("qqtxufoqfegukwsa")
    public suspend fun environmentUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentUrl = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("chjysxihllktvmxi")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("axuosplceomynhml")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("bukkvfhsydmqgscl")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'SalesforceV2'.
     */
    @JvmName("uwbibwkvkncxehfd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SalesforceV2LinkedServiceArgs = SalesforceV2LinkedServiceArgs(
        annotations = annotations,
        apiVersion = apiVersion,
        authenticationType = authenticationType,
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        environmentUrl = environmentUrl,
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
