@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SapOpenHubSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity source for SAP Business Warehouse Open Hub Destination source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property baseRequestId The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will be retrieved. The default value is 0. Type: integer (or Expression with resultType integer ).
 * @property customRfcReadTableFunctionModule Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property excludeLastRequest Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sapDataColumnDelimiter The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'SapOpenHubSource'.
 */
public data class SapOpenHubSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val baseRequestId: Output<Any>? = null,
    public val customRfcReadTableFunctionModule: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val excludeLastRequest: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val sapDataColumnDelimiter: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SapOpenHubSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SapOpenHubSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.SapOpenHubSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .baseRequestId(baseRequestId?.applyValue({ args0 -> args0 }))
            .customRfcReadTableFunctionModule(customRfcReadTableFunctionModule?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .excludeLastRequest(excludeLastRequest?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .sapDataColumnDelimiter(sapDataColumnDelimiter?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SapOpenHubSourceArgs].
 */
@PulumiTagMarker
public class SapOpenHubSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var baseRequestId: Output<Any>? = null

    private var customRfcReadTableFunctionModule: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var excludeLastRequest: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var queryTimeout: Output<Any>? = null

    private var sapDataColumnDelimiter: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("cocbtsabgsjxcpmu")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will be retrieved. The default value is 0. Type: integer (or Expression with resultType integer ).
     */
    @JvmName("xaapltavjtijcjqm")
    public suspend fun baseRequestId(`value`: Output<Any>) {
        this.baseRequestId = value
    }

    /**
     * @param value Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
     */
    @JvmName("seiyjruyitcyaidq")
    public suspend fun customRfcReadTableFunctionModule(`value`: Output<Any>) {
        this.customRfcReadTableFunctionModule = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("benmgdovbbumpmlh")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qcyshdgwyersxxar")
    public suspend fun excludeLastRequest(`value`: Output<Any>) {
        this.excludeLastRequest = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("clsjvchkmmkgaoun")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("surnnlkfaxratqbk")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     */
    @JvmName("mmvwahvehnfxdraq")
    public suspend fun sapDataColumnDelimiter(`value`: Output<Any>) {
        this.sapDataColumnDelimiter = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ynudesromexxhvte")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kdtsqmtqpbcdxaqw")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SapOpenHubSource'.
     */
    @JvmName("vvsgmowqsiuldtxp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("dttwmqswlenkaegn")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value The ID of request for delta loading. Once it is set, only data with requestId larger than the value of this property will be retrieved. The default value is 0. Type: integer (or Expression with resultType integer ).
     */
    @JvmName("ckhigmadewemapqr")
    public suspend fun baseRequestId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseRequestId = mapped
    }

    /**
     * @param value Specifies the custom RFC function module that will be used to read data from SAP Table. Type: string (or Expression with resultType string).
     */
    @JvmName("wroifccrnveefdnm")
    public suspend fun customRfcReadTableFunctionModule(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRfcReadTableFunctionModule = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lmljohdqhaulyyuh")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Whether to exclude the records of the last request. The default value is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jnogxsilopauajwy")
    public suspend fun excludeLastRequest(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeLastRequest = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("hmfefkgcbdpnqhhf")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("eggvnnraoglhjuub")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value The single character that will be used as delimiter passed to SAP RFC as well as splitting the output data retrieved. Type: string (or Expression with resultType string).
     */
    @JvmName("lrhduoonhmymfqoq")
    public suspend fun sapDataColumnDelimiter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapDataColumnDelimiter = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vicbqufanuawfmgf")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("xbujvwvxhwnlilwl")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'SapOpenHubSource'.
     */
    @JvmName("mpqfhdefiggfmmuo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SapOpenHubSourceArgs = SapOpenHubSourceArgs(
        additionalColumns = additionalColumns,
        baseRequestId = baseRequestId,
        customRfcReadTableFunctionModule = customRfcReadTableFunctionModule,
        disableMetricsCollection = disableMetricsCollection,
        excludeLastRequest = excludeLastRequest,
        maxConcurrentConnections = maxConcurrentConnections,
        queryTimeout = queryTimeout,
        sapDataColumnDelimiter = sapDataColumnDelimiter,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
