@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ScheduleTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that creates pipeline runs periodically, on schedule.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property pipelines Pipelines that need to be started.
 * @property recurrence Recurrence schedule configuration.
 * @property type Trigger type.
 * Expected value is 'ScheduleTrigger'.
 */
public data class ScheduleTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null,
    public val recurrence: Output<ScheduleTriggerRecurrenceArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ScheduleTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ScheduleTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.ScheduleTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .pipelines(
                pipelines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recurrence(recurrence.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTriggerArgs].
 */
@PulumiTagMarker
public class ScheduleTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null

    private var recurrence: Output<ScheduleTriggerRecurrenceArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("tbyvfpkwklbnptlu")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("wtueschxjkkbrger")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("paewvqaeiynbartq")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("rwoujyqdoluhijjq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("ikpaekispmpjmtrb")
    public suspend fun pipelines(`value`: Output<List<TriggerPipelineReferenceArgs>>) {
        this.pipelines = value
    }

    @JvmName("vkqowgwyjjptfxir")
    public suspend fun pipelines(vararg values: Output<TriggerPipelineReferenceArgs>) {
        this.pipelines = Output.all(values.asList())
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("tmqxxsrbghgyrfma")
    public suspend fun pipelines(values: List<Output<TriggerPipelineReferenceArgs>>) {
        this.pipelines = Output.all(values)
    }

    /**
     * @param value Recurrence schedule configuration.
     */
    @JvmName("fieciqurrwmwfrnl")
    public suspend fun recurrence(`value`: Output<ScheduleTriggerRecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value Trigger type.
     * Expected value is 'ScheduleTrigger'.
     */
    @JvmName("bqdgrcsydggxhdfr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("iegupbxmxvlfyawx")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("ytbvnvqueplecooo")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("sgcpqcoiidktpoci")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("qcpbtnchvdhfnmhb")
    public suspend fun pipelines(`value`: List<TriggerPipelineReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("ertyrgahcrrtsxjf")
    public suspend
    fun pipelines(argument: List<suspend TriggerPipelineReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("ioafwknskhapfsgi")
    public suspend fun pipelines(
        vararg
        argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("oyxmtbuyorvbnvyj")
    public suspend fun pipelines(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("wmlkokwenjqynlbt")
    public suspend fun pipelines(vararg values: TriggerPipelineReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param value Recurrence schedule configuration.
     */
    @JvmName("tqvqjsaechntbgdk")
    public suspend fun recurrence(`value`: ScheduleTriggerRecurrenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument Recurrence schedule configuration.
     */
    @JvmName("aegrltxivkbhnkmp")
    public suspend fun recurrence(argument: suspend ScheduleTriggerRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleTriggerRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'ScheduleTrigger'.
     */
    @JvmName("qbrlhpfjrghutspg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScheduleTriggerArgs = ScheduleTriggerArgs(
        annotations = annotations,
        description = description,
        pipelines = pipelines,
        recurrence = recurrence ?: throw PulumiNullFieldException("recurrence"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
