@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ScriptType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Script block of scripts.
 * @property parameters Array of script parameters. Type: array.
 * @property text The query text. Type: string (or Expression with resultType string).
 * @property type The type of the query. Type: string.
 */
public data class ScriptActivityScriptBlockArgs(
    public val parameters: Output<List<ScriptActivityParameterArgs>>? = null,
    public val text: Output<Any>,
    public val type: Output<Either<String, ScriptType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs =
        com.pulumi.azurenative.datafactory.inputs.ScriptActivityScriptBlockArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .text(text.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScriptActivityScriptBlockArgs].
 */
@PulumiTagMarker
public class ScriptActivityScriptBlockArgsBuilder internal constructor() {
    private var parameters: Output<List<ScriptActivityParameterArgs>>? = null

    private var text: Output<Any>? = null

    private var type: Output<Either<String, ScriptType>>? = null

    /**
     * @param value Array of script parameters. Type: array.
     */
    @JvmName("nvnxkfadkekjuula")
    public suspend fun parameters(`value`: Output<List<ScriptActivityParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("fpmsxncydnukiuqg")
    public suspend fun parameters(vararg values: Output<ScriptActivityParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Array of script parameters. Type: array.
     */
    @JvmName("ksyobfporpjbbfbs")
    public suspend fun parameters(values: List<Output<ScriptActivityParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The query text. Type: string (or Expression with resultType string).
     */
    @JvmName("knxlvqijhcbevepp")
    public suspend fun text(`value`: Output<Any>) {
        this.text = value
    }

    /**
     * @param value The type of the query. Type: string.
     */
    @JvmName("hnlfurnmsbmtjyjk")
    public suspend fun type(`value`: Output<Either<String, ScriptType>>) {
        this.type = value
    }

    /**
     * @param value Array of script parameters. Type: array.
     */
    @JvmName("jevvjorbufaxhgbr")
    public suspend fun parameters(`value`: List<ScriptActivityParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Array of script parameters. Type: array.
     */
    @JvmName("ulryogjqxafeagvv")
    public suspend
    fun parameters(argument: List<suspend ScriptActivityParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScriptActivityParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of script parameters. Type: array.
     */
    @JvmName("vhmitqowdxjmxxeb")
    public suspend fun parameters(
        vararg
        argument: suspend ScriptActivityParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScriptActivityParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Array of script parameters. Type: array.
     */
    @JvmName("guxxmdkxfjtsylyh")
    public suspend fun parameters(argument: suspend ScriptActivityParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScriptActivityParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Array of script parameters. Type: array.
     */
    @JvmName("qdrirkmjdbesgcvp")
    public suspend fun parameters(vararg values: ScriptActivityParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The query text. Type: string (or Expression with resultType string).
     */
    @JvmName("qwitepkqkjknsfnx")
    public suspend fun text(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.text = mapped
    }

    /**
     * @param value The type of the query. Type: string.
     */
    @JvmName("qqmmdqvkxctgwsfg")
    public suspend fun type(`value`: Either<String, ScriptType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the query. Type: string.
     */
    @JvmName("njrpxkkgpgshjlha")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScriptType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the query. Type: string.
     */
    @JvmName("tflbrfvxdwfselqi")
    public fun type(`value`: ScriptType) {
        val toBeMapped = Either.ofRight<String, ScriptType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScriptActivityScriptBlockArgs = ScriptActivityScriptBlockArgs(
        parameters = parameters,
        text = text ?: throw PulumiNullFieldException("text"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
