@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ScriptActivityTypePropertiesLogSettingsArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ScriptActivityLogDestination
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Log settings of script activity.
 * @property logDestination The destination of logs. Type: string.
 * @property logLocationSettings Log location settings customer needs to provide when enabling log.
 */
public data class ScriptActivityTypePropertiesLogSettingsArgs(
    public val logDestination: Output<Either<String, ScriptActivityLogDestination>>,
    public val logLocationSettings: Output<LogLocationSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ScriptActivityTypePropertiesLogSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.ScriptActivityTypePropertiesLogSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.ScriptActivityTypePropertiesLogSettingsArgs.builder()
            .logDestination(
                logDestination.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logLocationSettings(
                logLocationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ScriptActivityTypePropertiesLogSettingsArgs].
 */
@PulumiTagMarker
public class ScriptActivityTypePropertiesLogSettingsArgsBuilder internal constructor() {
    private var logDestination: Output<Either<String, ScriptActivityLogDestination>>? = null

    private var logLocationSettings: Output<LogLocationSettingsArgs>? = null

    /**
     * @param value The destination of logs. Type: string.
     */
    @JvmName("xsmvutcsousdsenr")
    public suspend fun logDestination(`value`: Output<Either<String, ScriptActivityLogDestination>>) {
        this.logDestination = value
    }

    /**
     * @param value Log location settings customer needs to provide when enabling log.
     */
    @JvmName("lddiehjmurisosox")
    public suspend fun logLocationSettings(`value`: Output<LogLocationSettingsArgs>) {
        this.logLocationSettings = value
    }

    /**
     * @param value The destination of logs. Type: string.
     */
    @JvmName("xvhyqiywcuewmdkc")
    public suspend fun logDestination(`value`: Either<String, ScriptActivityLogDestination>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param value The destination of logs. Type: string.
     */
    @JvmName("odkgknysalxldddc")
    public fun logDestination(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScriptActivityLogDestination>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param value The destination of logs. Type: string.
     */
    @JvmName("hcxgxdtslkigyspu")
    public fun logDestination(`value`: ScriptActivityLogDestination) {
        val toBeMapped = Either.ofRight<String, ScriptActivityLogDestination>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param value Log location settings customer needs to provide when enabling log.
     */
    @JvmName("odlqccpesgcakidv")
    public suspend fun logLocationSettings(`value`: LogLocationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLocationSettings = mapped
    }

    /**
     * @param argument Log location settings customer needs to provide when enabling log.
     */
    @JvmName("eloloyonogmqawxy")
    public suspend
    fun logLocationSettings(argument: suspend LogLocationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LogLocationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logLocationSettings = mapped
    }

    internal fun build(): ScriptActivityTypePropertiesLogSettingsArgs =
        ScriptActivityTypePropertiesLogSettingsArgs(
            logDestination = logDestination ?: throw PulumiNullFieldException("logDestination"),
            logLocationSettings = logLocationSettings,
        )
}
