@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SelfDependencyTumblingWindowTriggerReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Self referenced tumbling window trigger dependency.
 * @property offset Timespan applied to the start time of a tumbling window when evaluating dependency.
 * @property size The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
 * @property type The type of dependency reference.
 * Expected value is 'SelfDependencyTumblingWindowTriggerReference'.
 */
public data class SelfDependencyTumblingWindowTriggerReferenceArgs(
    public val offset: Output<String>,
    public val size: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SelfDependencyTumblingWindowTriggerReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.SelfDependencyTumblingWindowTriggerReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.SelfDependencyTumblingWindowTriggerReferenceArgs.builder()
            .offset(offset.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelfDependencyTumblingWindowTriggerReferenceArgs].
 */
@PulumiTagMarker
public class SelfDependencyTumblingWindowTriggerReferenceArgsBuilder internal constructor() {
    private var offset: Output<String>? = null

    private var size: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Timespan applied to the start time of a tumbling window when evaluating dependency.
     */
    @JvmName("wpjiuotxtdekxluw")
    public suspend fun offset(`value`: Output<String>) {
        this.offset = value
    }

    /**
     * @param value The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
     */
    @JvmName("emutaktmiddfjqui")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The type of dependency reference.
     * Expected value is 'SelfDependencyTumblingWindowTriggerReference'.
     */
    @JvmName("uhjgshlckchptaqn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Timespan applied to the start time of a tumbling window when evaluating dependency.
     */
    @JvmName("iaouljimhdnhylju")
    public suspend fun offset(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offset = mapped
    }

    /**
     * @param value The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used.
     */
    @JvmName("hkwqgwxatjnhkyki")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The type of dependency reference.
     * Expected value is 'SelfDependencyTumblingWindowTriggerReference'.
     */
    @JvmName("bcaofwcufomjojmu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SelfDependencyTumblingWindowTriggerReferenceArgs =
        SelfDependencyTumblingWindowTriggerReferenceArgs(
            offset = offset ?: throw PulumiNullFieldException("offset"),
            size = size,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
