@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SelfHostedIntegrationRuntimeArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Self-hosted integration runtime.
 * @property description Integration runtime description.
 * @property linkedInfo The base definition of a linked integration runtime.
 * @property selfContainedInteractiveAuthoringEnabled An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
 * @property type The type of integration runtime.
 * Expected value is 'SelfHosted'.
 */
public data class SelfHostedIntegrationRuntimeArgs(
    public val description: Output<String>? = null,
    public val linkedInfo:
    Output<Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>>? =
        null,
    public val selfContainedInteractiveAuthoringEnabled: Output<Boolean>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SelfHostedIntegrationRuntimeArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SelfHostedIntegrationRuntimeArgs =
        com.pulumi.azurenative.datafactory.inputs.SelfHostedIntegrationRuntimeArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .linkedInfo(
                linkedInfo?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .selfContainedInteractiveAuthoringEnabled(
                selfContainedInteractiveAuthoringEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelfHostedIntegrationRuntimeArgs].
 */
@PulumiTagMarker
public class SelfHostedIntegrationRuntimeArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var linkedInfo:
        Output<Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>>? =
        null

    private var selfContainedInteractiveAuthoringEnabled: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value Integration runtime description.
     */
    @JvmName("ttssjcfklklydmkh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The base definition of a linked integration runtime.
     */
    @JvmName("ilmbpglmdmtektlk")
    public suspend
    fun linkedInfo(`value`: Output<Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>>) {
        this.linkedInfo = value
    }

    /**
     * @param value An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
     */
    @JvmName("iaarnbartkmajdyj")
    public suspend fun selfContainedInteractiveAuthoringEnabled(`value`: Output<Boolean>) {
        this.selfContainedInteractiveAuthoringEnabled = value
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'SelfHosted'.
     */
    @JvmName("qxintcrkavcpfdnk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Integration runtime description.
     */
    @JvmName("xfbyerounaiyraxk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The base definition of a linked integration runtime.
     */
    @JvmName("cjlbxlgslabbvdil")
    public suspend
    fun linkedInfo(`value`: Either<LinkedIntegrationRuntimeKeyAuthorizationArgs, LinkedIntegrationRuntimeRbacAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedInfo = mapped
    }

    /**
     * @param value The base definition of a linked integration runtime.
     */
    @JvmName("gqncwtujqdwsfoyp")
    public fun linkedInfo(`value`: LinkedIntegrationRuntimeKeyAuthorizationArgs) {
        val toBeMapped = Either.ofLeft<LinkedIntegrationRuntimeKeyAuthorizationArgs,
            LinkedIntegrationRuntimeRbacAuthorizationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedInfo = mapped
    }

    /**
     * @param value The base definition of a linked integration runtime.
     */
    @JvmName("kqlqfivcfeqjamxg")
    public fun linkedInfo(`value`: LinkedIntegrationRuntimeRbacAuthorizationArgs) {
        val toBeMapped = Either.ofRight<LinkedIntegrationRuntimeKeyAuthorizationArgs,
            LinkedIntegrationRuntimeRbacAuthorizationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedInfo = mapped
    }

    /**
     * @param value An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay.
     */
    @JvmName("rmbibkpmxeehevvd")
    public suspend fun selfContainedInteractiveAuthoringEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfContainedInteractiveAuthoringEnabled = mapped
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'SelfHosted'.
     */
    @JvmName("jxivrjqaharmhwmt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SelfHostedIntegrationRuntimeArgs = SelfHostedIntegrationRuntimeArgs(
        description = description,
        linkedInfo = linkedInfo,
        selfContainedInteractiveAuthoringEnabled = selfContainedInteractiveAuthoringEnabled,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
