@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ServiceNowV2LinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ServiceNowV2AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ServiceNowV2 server linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to use.
 * @property clientId The client id for OAuth2 authentication.
 * @property clientSecret The client secret for OAuth2 authentication.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property endpoint The endpoint of the ServiceNowV2 server. (i.e. <instance>.service-now.com)
 * @property grantType GrantType for OAuth2 authentication. Default value is password.
 * @property parameters Parameters for linked service.
 * @property password The password corresponding to the user name for Basic and OAuth2 authentication.
 * @property type Type of linked service.
 * Expected value is 'ServiceNowV2'.
 * @property username The user name used to connect to the ServiceNowV2 server for Basic and OAuth2 authentication.
 */
public data class ServiceNowV2LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, ServiceNowV2AuthenticationType>>,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val endpoint: Output<Any>,
    public val grantType: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ServiceNowV2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ServiceNowV2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.ServiceNowV2LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .grantType(grantType?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNowV2LinkedServiceArgs].
 */
@PulumiTagMarker
public class ServiceNowV2LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, ServiceNowV2AuthenticationType>>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var endpoint: Output<Any>? = null

    private var grantType: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("syktwmlpymwwqwrr")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ijcqvyqbkvufvcup")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("gdpnjgtagrowrqpa")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("gjircoraasfihigy")
    public suspend
    fun authenticationType(`value`: Output<Either<String, ServiceNowV2AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The client id for OAuth2 authentication.
     */
    @JvmName("otvxhocchfujnfoh")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret for OAuth2 authentication.
     */
    @JvmName("qwgrfcuuwlsxxpuh")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("kvnwnltogwablsuj")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("uvcqhmstfjxhlxat")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("tppmhkixjmqynoet")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The endpoint of the ServiceNowV2 server. (i.e. <instance>.service-now.com)
     */
    @JvmName("xpjgauhukcvsewvh")
    public suspend fun endpoint(`value`: Output<Any>) {
        this.endpoint = value
    }

    /**
     * @param value GrantType for OAuth2 authentication. Default value is password.
     */
    @JvmName("ckninmwoujylhwad")
    public suspend fun grantType(`value`: Output<Any>) {
        this.grantType = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ejxwqplixvgxirkl")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password corresponding to the user name for Basic and OAuth2 authentication.
     */
    @JvmName("ryhqqifxhcbeuxwi")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'ServiceNowV2'.
     */
    @JvmName("tryqveqhurgmhuqa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name used to connect to the ServiceNowV2 server for Basic and OAuth2 authentication.
     */
    @JvmName("xerlhwrhdbppsmns")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("uovfcwpkadogmpjr")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("lixtfifbrisedhhf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("nmnodxrcxdgpisbi")
    public suspend fun authenticationType(`value`: Either<String, ServiceNowV2AuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("oqjxowteauflbndv")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceNowV2AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("jdvbshpofjvlhkhu")
    public fun authenticationType(`value`: ServiceNowV2AuthenticationType) {
        val toBeMapped = Either.ofRight<String, ServiceNowV2AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The client id for OAuth2 authentication.
     */
    @JvmName("fsjkvsleqcrsyvqy")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret for OAuth2 authentication.
     */
    @JvmName("dyycspmeftltsnvp")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret for OAuth2 authentication.
     */
    @JvmName("xftikgdiecgsfydo")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret for OAuth2 authentication.
     */
    @JvmName("chjocreiacrtgfhq")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mjdcmuawjfqmdjjg")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("sxxmbfckdevwyutx")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wuvdjkladdhcvoak")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("pveibqipsveyopdg")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The endpoint of the ServiceNowV2 server. (i.e. <instance>.service-now.com)
     */
    @JvmName("mhmlfpoacjdbyaoy")
    public suspend fun endpoint(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value GrantType for OAuth2 authentication. Default value is password.
     */
    @JvmName("itmequmqrwmakilp")
    public suspend fun grantType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantType = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("cyrurqagrqwqvvwp")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("wlupneaipjqeshoa")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("csvmlrdeigfaujxp")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password corresponding to the user name for Basic and OAuth2 authentication.
     */
    @JvmName("dxipvvujsmxvtlal")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name for Basic and OAuth2 authentication.
     */
    @JvmName("spdbqrsdbtcjhohi")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name for Basic and OAuth2 authentication.
     */
    @JvmName("ciayyofyxrodvuuu")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'ServiceNowV2'.
     */
    @JvmName("stbpynphthqadohb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name used to connect to the ServiceNowV2 server for Basic and OAuth2 authentication.
     */
    @JvmName("cfqmpulnqwxvqxyv")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ServiceNowV2LinkedServiceArgs = ServiceNowV2LinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        grantType = grantType,
        parameters = parameters,
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
