@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlPartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for Sql source partitioning.
 * @property partitionColumnName The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the primary key of the table is auto-detected and used as the partition column. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
 */
public data class SqlPartitionSettingsArgs(
    public val partitionColumnName: Output<Any>? = null,
    public val partitionLowerBound: Output<Any>? = null,
    public val partitionUpperBound: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlPartitionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlPartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlPartitionSettingsArgs.builder()
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 }))
            .partitionLowerBound(partitionLowerBound?.applyValue({ args0 -> args0 }))
            .partitionUpperBound(partitionUpperBound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPartitionSettingsArgs].
 */
@PulumiTagMarker
public class SqlPartitionSettingsArgsBuilder internal constructor() {
    private var partitionColumnName: Output<Any>? = null

    private var partitionLowerBound: Output<Any>? = null

    private var partitionUpperBound: Output<Any>? = null

    /**
     * @param value The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the primary key of the table is auto-detected and used as the partition column. Type: string (or Expression with resultType string).
     */
    @JvmName("byytkuecigmxgops")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
     */
    @JvmName("ysamrgehybkajira")
    public suspend fun partitionLowerBound(`value`: Output<Any>) {
        this.partitionLowerBound = value
    }

    /**
     * @param value The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
     */
    @JvmName("icmseygcnybjvpct")
    public suspend fun partitionUpperBound(`value`: Output<Any>) {
        this.partitionUpperBound = value
    }

    /**
     * @param value The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the primary key of the table is auto-detected and used as the partition column. Type: string (or Expression with resultType string).
     */
    @JvmName("smxurmooqcepjpho")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    /**
     * @param value The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
     */
    @JvmName("eaobotldlnrxuvnw")
    public suspend fun partitionLowerBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionLowerBound = mapped
    }

    /**
     * @param value The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride, not for filtering the rows in table. All rows in the table or query result will be partitioned and copied. Type: string (or Expression with resultType string).
     */
    @JvmName("eqjitjwavoqcwuaf")
    public suspend fun partitionUpperBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionUpperBound = mapped
    }

    internal fun build(): SqlPartitionSettingsArgs = SqlPartitionSettingsArgs(
        partitionColumnName = partitionColumnName,
        partitionLowerBound = partitionLowerBound,
        partitionUpperBound = partitionUpperBound,
    )
}
