@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlServerSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity SQL server sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property preCopyScript SQL pre-copy script. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property sqlWriterStoredProcedureName SQL writer stored procedure name. Type: string (or Expression with resultType string).
 * @property sqlWriterTableType SQL writer table type. Type: string (or Expression with resultType string).
 * @property sqlWriterUseTableLock Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
 * @property storedProcedureParameters SQL stored procedure parameters.
 * @property storedProcedureTableTypeParameterName The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
 * @property tableOption The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
 * @property type Copy sink type.
 * Expected value is 'SqlServerSink'.
 * @property upsertSettings SQL upsert settings.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Write behavior when copying data into sql server. Type: string (or Expression with resultType string).
 */
public data class SqlServerSinkArgs(
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val preCopyScript: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val sqlWriterStoredProcedureName: Output<Any>? = null,
    public val sqlWriterTableType: Output<Any>? = null,
    public val sqlWriterUseTableLock: Output<Any>? = null,
    public val storedProcedureParameters: Output<Any>? = null,
    public val storedProcedureTableTypeParameterName: Output<Any>? = null,
    public val tableOption: Output<Any>? = null,
    public val type: Output<String>,
    public val upsertSettings: Output<SqlUpsertSettingsArgs>? = null,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlServerSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlServerSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlServerSinkArgs.builder()
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .preCopyScript(preCopyScript?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .sqlWriterStoredProcedureName(sqlWriterStoredProcedureName?.applyValue({ args0 -> args0 }))
            .sqlWriterTableType(sqlWriterTableType?.applyValue({ args0 -> args0 }))
            .sqlWriterUseTableLock(sqlWriterUseTableLock?.applyValue({ args0 -> args0 }))
            .storedProcedureParameters(storedProcedureParameters?.applyValue({ args0 -> args0 }))
            .storedProcedureTableTypeParameterName(
                storedProcedureTableTypeParameterName?.applyValue({ args0 ->
                    args0
                }),
            )
            .tableOption(tableOption?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .upsertSettings(upsertSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(writeBehavior?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlServerSinkArgs].
 */
@PulumiTagMarker
public class SqlServerSinkArgsBuilder internal constructor() {
    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var preCopyScript: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var sqlWriterStoredProcedureName: Output<Any>? = null

    private var sqlWriterTableType: Output<Any>? = null

    private var sqlWriterUseTableLock: Output<Any>? = null

    private var storedProcedureParameters: Output<Any>? = null

    private var storedProcedureTableTypeParameterName: Output<Any>? = null

    private var tableOption: Output<Any>? = null

    private var type: Output<String>? = null

    private var upsertSettings: Output<SqlUpsertSettingsArgs>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Any>? = null

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("iffkrgwefpksjbfc")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("xbnxnvnrnlhcsqoe")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("dpbkdnbwrybdehjj")
    public suspend fun preCopyScript(`value`: Output<Any>) {
        this.preCopyScript = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qkkublyxsrsfgiyr")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("kyvpdwbdxfjwijem")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value SQL writer stored procedure name. Type: string (or Expression with resultType string).
     */
    @JvmName("whmisamygxcipleu")
    public suspend fun sqlWriterStoredProcedureName(`value`: Output<Any>) {
        this.sqlWriterStoredProcedureName = value
    }

    /**
     * @param value SQL writer table type. Type: string (or Expression with resultType string).
     */
    @JvmName("rjcjpruwoaradonl")
    public suspend fun sqlWriterTableType(`value`: Output<Any>) {
        this.sqlWriterTableType = value
    }

    /**
     * @param value Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uuxsdlhporfsojxx")
    public suspend fun sqlWriterUseTableLock(`value`: Output<Any>) {
        this.sqlWriterUseTableLock = value
    }

    /**
     * @param value SQL stored procedure parameters.
     */
    @JvmName("trnsrucsxcynvysn")
    public suspend fun storedProcedureParameters(`value`: Output<Any>) {
        this.storedProcedureParameters = value
    }

    /**
     * @param value The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
     */
    @JvmName("deshcrbocmsbhhrd")
    public suspend fun storedProcedureTableTypeParameterName(`value`: Output<Any>) {
        this.storedProcedureTableTypeParameterName = value
    }

    /**
     * @param value The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JvmName("gnadhspnmagqcaxk")
    public suspend fun tableOption(`value`: Output<Any>) {
        this.tableOption = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SqlServerSink'.
     */
    @JvmName("yeuknajfgxaimqqr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value SQL upsert settings.
     */
    @JvmName("cyqytmkhngygrsba")
    public suspend fun upsertSettings(`value`: Output<SqlUpsertSettingsArgs>) {
        this.upsertSettings = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("vuicekdyalwgmoqi")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("fpbxqdcrbvuobngm")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value Write behavior when copying data into sql server. Type: string (or Expression with resultType string).
     */
    @JvmName("okuphofwpsvihysk")
    public suspend fun writeBehavior(`value`: Output<Any>) {
        this.writeBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uebwuqxditwlyjic")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qpiwpkskvmkqbrvl")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("vjqgeqiffkueosyc")
    public suspend fun preCopyScript(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preCopyScript = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("plcyebvlspweiyxo")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("inbscokbfuwigmdv")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value SQL writer stored procedure name. Type: string (or Expression with resultType string).
     */
    @JvmName("phcqeawjfkpoigxc")
    public suspend fun sqlWriterStoredProcedureName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlWriterStoredProcedureName = mapped
    }

    /**
     * @param value SQL writer table type. Type: string (or Expression with resultType string).
     */
    @JvmName("neupeblytiaidkjj")
    public suspend fun sqlWriterTableType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlWriterTableType = mapped
    }

    /**
     * @param value Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("avljlxqaqiysdgbx")
    public suspend fun sqlWriterUseTableLock(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlWriterUseTableLock = mapped
    }

    /**
     * @param value SQL stored procedure parameters.
     */
    @JvmName("bgdymopdctjshejm")
    public suspend fun storedProcedureParameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedProcedureParameters = mapped
    }

    /**
     * @param value The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
     */
    @JvmName("hduowucruofvriby")
    public suspend fun storedProcedureTableTypeParameterName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedProcedureTableTypeParameterName = mapped
    }

    /**
     * @param value The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression with resultType string).
     */
    @JvmName("vaskpxqcfcgnlmrr")
    public suspend fun tableOption(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableOption = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'SqlServerSink'.
     */
    @JvmName("dwcdhicthulmqnyh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value SQL upsert settings.
     */
    @JvmName("axxgwdvpqxarfkep")
    public suspend fun upsertSettings(`value`: SqlUpsertSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upsertSettings = mapped
    }

    /**
     * @param argument SQL upsert settings.
     */
    @JvmName("ffdrpswcvdlxlxii")
    public suspend fun upsertSettings(argument: suspend SqlUpsertSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SqlUpsertSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upsertSettings = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("ethqdwjeeektxtul")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("pqywcnhibdtsujoo")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value Write behavior when copying data into sql server. Type: string (or Expression with resultType string).
     */
    @JvmName("lkpdpkgpnmbwfxru")
    public suspend fun writeBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): SqlServerSinkArgs = SqlServerSinkArgs(
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        preCopyScript = preCopyScript,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        sqlWriterStoredProcedureName = sqlWriterStoredProcedureName,
        sqlWriterTableType = sqlWriterTableType,
        sqlWriterUseTableLock = sqlWriterUseTableLock,
        storedProcedureParameters = storedProcedureParameters,
        storedProcedureTableTypeParameterName = storedProcedureTableTypeParameterName,
        tableOption = tableOption,
        type = type ?: throw PulumiNullFieldException("type"),
        upsertSettings = upsertSettings,
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior,
    )
}
