@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SqlUpsertSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sql upsert option settings
 * @property interimSchemaName Schema name for interim table. Type: string (or Expression with resultType string).
 * @property keys Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
 * @property useTempDB Specifies whether to use temp db for upsert interim table. Type: boolean (or Expression with resultType boolean).
 */
public data class SqlUpsertSettingsArgs(
    public val interimSchemaName: Output<Any>? = null,
    public val keys: Output<Any>? = null,
    public val useTempDB: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SqlUpsertSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SqlUpsertSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.SqlUpsertSettingsArgs.builder()
            .interimSchemaName(interimSchemaName?.applyValue({ args0 -> args0 }))
            .keys(keys?.applyValue({ args0 -> args0 }))
            .useTempDB(useTempDB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlUpsertSettingsArgs].
 */
@PulumiTagMarker
public class SqlUpsertSettingsArgsBuilder internal constructor() {
    private var interimSchemaName: Output<Any>? = null

    private var keys: Output<Any>? = null

    private var useTempDB: Output<Any>? = null

    /**
     * @param value Schema name for interim table. Type: string (or Expression with resultType string).
     */
    @JvmName("woafqwlynmutmfsf")
    public suspend fun interimSchemaName(`value`: Output<Any>) {
        this.interimSchemaName = value
    }

    /**
     * @param value Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("dqdbkykfxsxbhyvj")
    public suspend fun keys(`value`: Output<Any>) {
        this.keys = value
    }

    /**
     * @param value Specifies whether to use temp db for upsert interim table. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jrylgrjjfgflfqtj")
    public suspend fun useTempDB(`value`: Output<Any>) {
        this.useTempDB = value
    }

    /**
     * @param value Schema name for interim table. Type: string (or Expression with resultType string).
     */
    @JvmName("ukmrwbabufvhekkg")
    public suspend fun interimSchemaName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interimSchemaName = mapped
    }

    /**
     * @param value Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("gvqdpsrywahpfmtg")
    public suspend fun keys(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param value Specifies whether to use temp db for upsert interim table. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("tyclqjynasujxrhk")
    public suspend fun useTempDB(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTempDB = mapped
    }

    internal fun build(): SqlUpsertSettingsArgs = SqlUpsertSettingsArgs(
        interimSchemaName = interimSchemaName,
        keys = keys,
        useTempDB = useTempDB,
    )
}
