@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SwitchActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This activity evaluates an expression and executes activities under the cases property that correspond to the expression evaluation expected in the equals property.
 * @property cases List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
 * @property defaultActivities List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property name Activity name.
 * @property on An expression that would evaluate to a string or integer. This is used to determine the block of activities in cases that will be executed.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Switch'.
 * @property userProperties Activity user properties.
 */
public data class SwitchActivityArgs(
    public val cases: Output<List<SwitchCaseArgs>>? = null,
    public val defaultActivities: Output<List<Any>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val on: Output<ExpressionArgs>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SwitchActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SwitchActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.SwitchActivityArgs.builder()
            .cases(cases?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .defaultActivities(defaultActivities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .on(on.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SwitchActivityArgs].
 */
@PulumiTagMarker
public class SwitchActivityArgsBuilder internal constructor() {
    private var cases: Output<List<SwitchCaseArgs>>? = null

    private var defaultActivities: Output<List<Any>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var on: Output<ExpressionArgs>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("eudjuvbxuqpmevfs")
    public suspend fun cases(`value`: Output<List<SwitchCaseArgs>>) {
        this.cases = value
    }

    @JvmName("igcsifgtbimebvwo")
    public suspend fun cases(vararg values: Output<SwitchCaseArgs>) {
        this.cases = Output.all(values.asList())
    }

    /**
     * @param values List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("vojnvvrvxgnayoli")
    public suspend fun cases(values: List<Output<SwitchCaseArgs>>) {
        this.cases = Output.all(values)
    }

    /**
     * @param value List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("vjypahekykosqifh")
    public suspend fun defaultActivities(`value`: Output<List<Any>>) {
        this.defaultActivities = value
    }

    @JvmName("yixdeopekvbwfete")
    public suspend fun defaultActivities(vararg values: Output<Any>) {
        this.defaultActivities = Output.all(values.asList())
    }

    /**
     * @param values List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("rihhjgvjikrjwqtt")
    public suspend fun defaultActivities(values: List<Output<Any>>) {
        this.defaultActivities = Output.all(values)
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("sqecywxakyshmwfd")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("jblahbkjjljyrqdk")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("kdqqtuixhtkxwofk")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("iipirudhegsxyvvi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("eniemcfhvfkdylfu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An expression that would evaluate to a string or integer. This is used to determine the block of activities in cases that will be executed.
     */
    @JvmName("gexqmmlxbnhimxct")
    public suspend fun on(`value`: Output<ExpressionArgs>) {
        this.on = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("sfpdauurfuavpnlw")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("tyejqiwwoxfptyub")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Switch'.
     */
    @JvmName("cdikgjxfapwghqbe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("dqiwwwekvlvsdsml")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("orsnilkcvxcoqlyj")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("hjjwqobdqgkvllrl")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("jptiomtsloiynkji")
    public suspend fun cases(`value`: List<SwitchCaseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cases = mapped
    }

    /**
     * @param argument List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("ucjduscebeplwmuu")
    public suspend fun cases(argument: List<suspend SwitchCaseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SwitchCaseArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.cases = mapped
    }

    /**
     * @param argument List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("ogcxkvgiuspgegnt")
    public suspend fun cases(vararg argument: suspend SwitchCaseArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SwitchCaseArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.cases = mapped
    }

    /**
     * @param argument List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("lxisthfeycixdkjw")
    public suspend fun cases(argument: suspend SwitchCaseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SwitchCaseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.cases = mapped
    }

    /**
     * @param values List of cases that correspond to expected values of the 'on' property. This is an optional property and if not provided, the activity will execute activities provided in defaultActivities.
     */
    @JvmName("uolnhusjlhoyiofx")
    public suspend fun cases(vararg values: SwitchCaseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cases = mapped
    }

    /**
     * @param value List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("ahbbvwyfdtokasgw")
    public suspend fun defaultActivities(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultActivities = mapped
    }

    /**
     * @param values List of activities to execute if no case condition is satisfied. This is an optional property and if not provided, the activity will exit without any action.
     */
    @JvmName("ymgmcovssdoolasq")
    public suspend fun defaultActivities(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultActivities = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("eqccjceggevrlwln")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("gskgbiugacsutxud")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("lfoqucogkudsgwmb")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("exedcbsvacleeboc")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("ovwhhygniiqmkdia")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("xixsnycssblcllkc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("yfpsgejfpdumrctm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An expression that would evaluate to a string or integer. This is used to determine the block of activities in cases that will be executed.
     */
    @JvmName("uonqnpjwtfomvitk")
    public suspend fun on(`value`: ExpressionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.on = mapped
    }

    /**
     * @param argument An expression that would evaluate to a string or integer. This is used to determine the block of activities in cases that will be executed.
     */
    @JvmName("jgvwyndnoabrtvul")
    public suspend fun on(argument: suspend ExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.on = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("grqsjearqesaifbt")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("ootbamjfjirrxfer")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("bttfgjpdnphjjwnl")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("kfrnbqysxvlewfcy")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("yjqkxsaltwgacimy")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("vnhkqgdnuoixurns")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Switch'.
     */
    @JvmName("ctnjlgxbisqlkvot")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("gvkekuykhrrembam")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("ywovqifjembpctfk")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("jpvryyxhoillpwys")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("ilenbpkloishkdlj")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("ctblebameaoeaiap")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): SwitchActivityArgs = SwitchActivityArgs(
        cases = cases,
        defaultActivities = defaultActivities,
        dependsOn = dependsOn,
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        on = on ?: throw PulumiNullFieldException("on"),
        onInactiveMarkAs = onInactiveMarkAs,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
