@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.SybaseLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.SybaseAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Sybase data source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType AuthenticationType to be used for connection.
 * @property connectVia The integration runtime reference.
 * @property database Database name for connection. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password Password for authentication.
 * @property schema Schema name for connection. Type: string (or Expression with resultType string).
 * @property server Server name for connection. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Sybase'.
 * @property username Username for authentication. Type: string (or Expression with resultType string).
 */
public data class SybaseLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, SybaseAuthenticationType>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val database: Output<Any>,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val schema: Output<Any>? = null,
    public val server: Output<Any>,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.SybaseLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.SybaseLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.SybaseLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .database(database.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SybaseLinkedServiceArgs].
 */
@PulumiTagMarker
public class SybaseLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, SybaseAuthenticationType>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var schema: Output<Any>? = null

    private var server: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ndqtlqchxewqiocq")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("pwyugdwruhpfoxoe")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("iomsuinpaqxpxloa")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value AuthenticationType to be used for connection.
     */
    @JvmName("ecpackknqwgwwnjb")
    public suspend fun authenticationType(`value`: Output<Either<String, SybaseAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mtjxbggayjnxblou")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Database name for connection. Type: string (or Expression with resultType string).
     */
    @JvmName("abvbjlktiimhnipr")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("uvewevxuobmdrrme")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ujfagkrfidymvjjr")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("rndolnhnblglenat")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("pjjrmrmkhmvnuxxn")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Schema name for connection. Type: string (or Expression with resultType string).
     */
    @JvmName("qbgbfsooqvxvmicb")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Server name for connection. Type: string (or Expression with resultType string).
     */
    @JvmName("srpkdbexqecrammk")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Sybase'.
     */
    @JvmName("ljlmsfspiovqpwpj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username for authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("eddrqmckkxguntkt")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vnyitfqftdcyvyrs")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("esaamoaiuoputbaj")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value AuthenticationType to be used for connection.
     */
    @JvmName("weuujicjkrvamolm")
    public suspend fun authenticationType(`value`: Either<String, SybaseAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value AuthenticationType to be used for connection.
     */
    @JvmName("qvugguhfflmukqde")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SybaseAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value AuthenticationType to be used for connection.
     */
    @JvmName("dxeollwcytrumeld")
    public fun authenticationType(`value`: SybaseAuthenticationType) {
        val toBeMapped = Either.ofRight<String, SybaseAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("webqoojhwseuantp")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("ctuhaprwiqcjxtle")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Database name for connection. Type: string (or Expression with resultType string).
     */
    @JvmName("pwnonivvxrefdogo")
    public suspend fun database(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("dpdvimardrnafmbd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("bcjkbgeidofqbjgp")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("swqtdmsexypuiaka")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("sqdreegabwnukxod")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("joqlgsefbndmdltq")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("yvqacerjcavdkmpf")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("oaflqvxwaedjkybo")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("rnycvwtcxpewsoiv")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Schema name for connection. Type: string (or Expression with resultType string).
     */
    @JvmName("hmrvuvvkdurproqh")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Server name for connection. Type: string (or Expression with resultType string).
     */
    @JvmName("aueqtlcatopkcvmx")
    public suspend fun server(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Sybase'.
     */
    @JvmName("xgancspfqakrisov")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username for authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("luobhrsaokurhqjj")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): SybaseLinkedServiceArgs = SybaseLinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType,
        connectVia = connectVia,
        database = database ?: throw PulumiNullFieldException("database"),
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        schema = schema,
        server = server ?: throw PulumiNullFieldException("server"),
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
