@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TarGZipReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The TarGZip compression read settings.
 * @property preserveCompressionFileNameAsFolder Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
 * @property type The Compression setting type.
 * Expected value is 'TarGZipReadSettings'.
 */
public data class TarGZipReadSettingsArgs(
    public val preserveCompressionFileNameAsFolder: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TarGZipReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TarGZipReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.TarGZipReadSettingsArgs.builder()
            .preserveCompressionFileNameAsFolder(
                preserveCompressionFileNameAsFolder?.applyValue({ args0 ->
                    args0
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TarGZipReadSettingsArgs].
 */
@PulumiTagMarker
public class TarGZipReadSettingsArgsBuilder internal constructor() {
    private var preserveCompressionFileNameAsFolder: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("twpukcsilwkdqbhf")
    public suspend fun preserveCompressionFileNameAsFolder(`value`: Output<Any>) {
        this.preserveCompressionFileNameAsFolder = value
    }

    /**
     * @param value The Compression setting type.
     * Expected value is 'TarGZipReadSettings'.
     */
    @JvmName("twvbwnmuttwtvljp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("agxnpumhecrgjcqq")
    public suspend fun preserveCompressionFileNameAsFolder(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveCompressionFileNameAsFolder = mapped
    }

    /**
     * @param value The Compression setting type.
     * Expected value is 'TarGZipReadSettings'.
     */
    @JvmName("dnsongtiorvynnxd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TarGZipReadSettingsArgs = TarGZipReadSettingsArgs(
        preserveCompressionFileNameAsFolder = preserveCompressionFileNameAsFolder,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
