@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TeradataPartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for teradata source partitioning.
 * @property partitionColumnName The name of the column that will be used for proceeding range or hash partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class TeradataPartitionSettingsArgs(
    public val partitionColumnName: Output<Any>? = null,
    public val partitionLowerBound: Output<Any>? = null,
    public val partitionUpperBound: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TeradataPartitionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TeradataPartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.TeradataPartitionSettingsArgs.builder()
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 }))
            .partitionLowerBound(partitionLowerBound?.applyValue({ args0 -> args0 }))
            .partitionUpperBound(partitionUpperBound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TeradataPartitionSettingsArgs].
 */
@PulumiTagMarker
public class TeradataPartitionSettingsArgsBuilder internal constructor() {
    private var partitionColumnName: Output<Any>? = null

    private var partitionLowerBound: Output<Any>? = null

    private var partitionUpperBound: Output<Any>? = null

    /**
     * @param value The name of the column that will be used for proceeding range or hash partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("vtpbtjaelxbmhmpr")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("yyoakjltootwdoew")
    public suspend fun partitionLowerBound(`value`: Output<Any>) {
        this.partitionLowerBound = value
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("asunsyanttxykvep")
    public suspend fun partitionUpperBound(`value`: Output<Any>) {
        this.partitionUpperBound = value
    }

    /**
     * @param value The name of the column that will be used for proceeding range or hash partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("paeesojiviqhoppj")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("ivifoapqdbxvxilh")
    public suspend fun partitionLowerBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionLowerBound = mapped
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("duyhdwgoctvnclki")
    public suspend fun partitionUpperBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionUpperBound = mapped
    }

    internal fun build(): TeradataPartitionSettingsArgs = TeradataPartitionSettingsArgs(
        partitionColumnName = partitionColumnName,
        partitionLowerBound = partitionLowerBound,
        partitionUpperBound = partitionUpperBound,
    )
}
