@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.TumblingWindowFrequency
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that schedules pipeline runs for all fixed time interval windows from a start time without gaps and also supports backfill scenarios (when start time is in the past).
 * @property annotations List of tags that can be used for describing the trigger.
 * @property delay Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property dependsOn Triggers that this trigger depends on. Only tumbling window triggers are supported.
 * @property description Trigger description.
 * @property endTime The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
 * @property frequency The frequency of the time windows.
 * @property interval The interval of the time windows. The minimum interval allowed is 15 Minutes.
 * @property maxConcurrency The max number of parallel time windows (ready for execution) for which a new run is triggered.
 * @property pipeline Pipeline for which runs are created when an event is fired for trigger window that is ready.
 * @property retryPolicy Retry policy that will be applied for failed pipeline runs.
 * @property startTime The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
 * @property type Trigger type.
 * Expected value is 'TumblingWindowTrigger'.
 */
public data class TumblingWindowTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val delay: Output<Any>? = null,
    public val dependsOn: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val frequency: Output<Either<String, TumblingWindowFrequency>>,
    public val interval: Output<Int>,
    public val maxConcurrency: Output<Int>,
    public val pipeline: Output<TriggerPipelineReferenceArgs>,
    public val retryPolicy: Output<RetryPolicyArgs>? = null,
    public val startTime: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.TumblingWindowTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .delay(delay?.applyValue({ args0 -> args0 }))
            .dependsOn(dependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .frequency(
                frequency.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interval(interval.applyValue({ args0 -> args0 }))
            .maxConcurrency(maxConcurrency.applyValue({ args0 -> args0 }))
            .pipeline(pipeline.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTime(startTime.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TumblingWindowTriggerArgs].
 */
@PulumiTagMarker
public class TumblingWindowTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var delay: Output<Any>? = null

    private var dependsOn: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var endTime: Output<String>? = null

    private var frequency: Output<Either<String, TumblingWindowFrequency>>? = null

    private var interval: Output<Int>? = null

    private var maxConcurrency: Output<Int>? = null

    private var pipeline: Output<TriggerPipelineReferenceArgs>? = null

    private var retryPolicy: Output<RetryPolicyArgs>? = null

    private var startTime: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("riyiqxjbkgdutfsl")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("styvtteriyiyuape")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("esyaxvfcregqkjkg")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("qurihohxkdeejuny")
    public suspend fun delay(`value`: Output<Any>) {
        this.delay = value
    }

    /**
     * @param value Triggers that this trigger depends on. Only tumbling window triggers are supported.
     */
    @JvmName("ksngqxvwqqrfdpbo")
    public suspend fun dependsOn(`value`: Output<List<Any>>) {
        this.dependsOn = value
    }

    @JvmName("lrpvyxhgyirvmbsh")
    public suspend fun dependsOn(vararg values: Output<Any>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Triggers that this trigger depends on. Only tumbling window triggers are supported.
     */
    @JvmName("hrdeujyerhggdyxm")
    public suspend fun dependsOn(values: List<Output<Any>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("vpaaucxnpspraotu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
     */
    @JvmName("syxrfxkjqtkuymwf")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The frequency of the time windows.
     */
    @JvmName("dxpfvtuvuuswaksd")
    public suspend fun frequency(`value`: Output<Either<String, TumblingWindowFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value The interval of the time windows. The minimum interval allowed is 15 Minutes.
     */
    @JvmName("dsbfutccnttpygno")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The max number of parallel time windows (ready for execution) for which a new run is triggered.
     */
    @JvmName("bfhsrvlkgqtykkmf")
    public suspend fun maxConcurrency(`value`: Output<Int>) {
        this.maxConcurrency = value
    }

    /**
     * @param value Pipeline for which runs are created when an event is fired for trigger window that is ready.
     */
    @JvmName("cpsninelrgfgyrbe")
    public suspend fun pipeline(`value`: Output<TriggerPipelineReferenceArgs>) {
        this.pipeline = value
    }

    /**
     * @param value Retry policy that will be applied for failed pipeline runs.
     */
    @JvmName("nuigviccyfrmtcvi")
    public suspend fun retryPolicy(`value`: Output<RetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
     */
    @JvmName("jjmndtforypnqaol")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Trigger type.
     * Expected value is 'TumblingWindowTrigger'.
     */
    @JvmName("yylasmgusycdrmcm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("cckbdkuaqqimoagf")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("ddupmxbmilvrotyy")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("dtxerrwvoecjmfen")
    public suspend fun delay(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delay = mapped
    }

    /**
     * @param value Triggers that this trigger depends on. Only tumbling window triggers are supported.
     */
    @JvmName("dcjqlknumnghalrp")
    public suspend fun dependsOn(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param values Triggers that this trigger depends on. Only tumbling window triggers are supported.
     */
    @JvmName("xsvioatdwbpmcper")
    public suspend fun dependsOn(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("opqtklrwqpumhsps")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
     */
    @JvmName("ysvquebncovolkaf")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The frequency of the time windows.
     */
    @JvmName("rydbyuqqdtpximco")
    public suspend fun frequency(`value`: Either<String, TumblingWindowFrequency>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The frequency of the time windows.
     */
    @JvmName("cagbbjanpaeaxqxe")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TumblingWindowFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The frequency of the time windows.
     */
    @JvmName("rypliqxcvidxdmdj")
    public fun frequency(`value`: TumblingWindowFrequency) {
        val toBeMapped = Either.ofRight<String, TumblingWindowFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The interval of the time windows. The minimum interval allowed is 15 Minutes.
     */
    @JvmName("jgehrhrlmiwebxfl")
    public suspend fun interval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The max number of parallel time windows (ready for execution) for which a new run is triggered.
     */
    @JvmName("bytglimlllisodtv")
    public suspend fun maxConcurrency(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value Pipeline for which runs are created when an event is fired for trigger window that is ready.
     */
    @JvmName("deyaionmooshclcq")
    public suspend fun pipeline(`value`: TriggerPipelineReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipeline = mapped
    }

    /**
     * @param argument Pipeline for which runs are created when an event is fired for trigger window that is ready.
     */
    @JvmName("vpujxltvagqqxgsr")
    public suspend fun pipeline(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerPipelineReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pipeline = mapped
    }

    /**
     * @param value Retry policy that will be applied for failed pipeline runs.
     */
    @JvmName("byoxyynqjjsheeyx")
    public suspend fun retryPolicy(`value`: RetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument Retry policy that will be applied for failed pipeline runs.
     */
    @JvmName("nvjwclfcipsfxqpq")
    public suspend fun retryPolicy(argument: suspend RetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported.
     */
    @JvmName("oukgdndydygwagpw")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'TumblingWindowTrigger'.
     */
    @JvmName("irltqvkjwonlxqaw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TumblingWindowTriggerArgs = TumblingWindowTriggerArgs(
        annotations = annotations,
        delay = delay,
        dependsOn = dependsOn,
        description = description,
        endTime = endTime,
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
        interval = interval ?: throw PulumiNullFieldException("interval"),
        maxConcurrency = maxConcurrency ?: throw PulumiNullFieldException("maxConcurrency"),
        pipeline = pipeline ?: throw PulumiNullFieldException("pipeline"),
        retryPolicy = retryPolicy,
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
