@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.WebActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.azurenative.datafactory.kotlin.enums.WebActivityMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Web activity.
 * @property authentication Authentication method used for calling the endpoint.
 * @property body Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property datasets List of datasets passed to web endpoint.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property disableCertValidation When set to true, Certificate validation will be disabled.
 * @property headers Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
 * @property httpRequestTimeout Timeout for the HTTP request to get a response. Format is in TimeSpan (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00 (1 minute). The range is from 1 to 10 minutes
 * @property linkedServiceName Linked service reference.
 * @property linkedServices List of linked services passed to web endpoint.
 * @property method Rest API method for target endpoint.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property turnOffAsync Option to disable invoking HTTP GET on location given in response header of a HTTP 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false then continues to invoke HTTP GET call on location given in http response headers.
 * @property type Type of activity.
 * Expected value is 'WebActivity'.
 * @property url Web activity target endpoint and path. Type: string (or Expression with resultType string).
 * @property userProperties Activity user properties.
 */
public data class WebActivityArgs(
    public val authentication: Output<WebActivityAuthenticationArgs>? = null,
    public val body: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val datasets: Output<List<DatasetReferenceArgs>>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val disableCertValidation: Output<Boolean>? = null,
    public val headers: Output<Map<String, String>>? = null,
    public val httpRequestTimeout: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val linkedServices: Output<List<LinkedServiceReferenceArgs>>? = null,
    public val method: Output<Either<String, WebActivityMethod>>,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val turnOffAsync: Output<Boolean>? = null,
    public val type: Output<String>,
    public val url: Output<Any>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.WebActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.WebActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.WebActivityArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datasets(
                datasets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .disableCertValidation(disableCertValidation?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .httpRequestTimeout(httpRequestTimeout?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServices(
                linkedServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .method(
                method.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .turnOffAsync(turnOffAsync?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebActivityArgs].
 */
@PulumiTagMarker
public class WebActivityArgsBuilder internal constructor() {
    private var authentication: Output<WebActivityAuthenticationArgs>? = null

    private var body: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var datasets: Output<List<DatasetReferenceArgs>>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var disableCertValidation: Output<Boolean>? = null

    private var headers: Output<Map<String, String>>? = null

    private var httpRequestTimeout: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var linkedServices: Output<List<LinkedServiceReferenceArgs>>? = null

    private var method: Output<Either<String, WebActivityMethod>>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var turnOffAsync: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var url: Output<Any>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Authentication method used for calling the endpoint.
     */
    @JvmName("kvhvvygirdmpjvpe")
    public suspend fun authentication(`value`: Output<WebActivityAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
     */
    @JvmName("uusbfbdeedscwmci")
    public suspend fun body(`value`: Output<Any>) {
        this.body = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("rpvynwknnnaefbte")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value List of datasets passed to web endpoint.
     */
    @JvmName("svkajktmfnjehwut")
    public suspend fun datasets(`value`: Output<List<DatasetReferenceArgs>>) {
        this.datasets = value
    }

    @JvmName("ekxyhbysrqdhcguk")
    public suspend fun datasets(vararg values: Output<DatasetReferenceArgs>) {
        this.datasets = Output.all(values.asList())
    }

    /**
     * @param values List of datasets passed to web endpoint.
     */
    @JvmName("dloiaanfrlribssi")
    public suspend fun datasets(values: List<Output<DatasetReferenceArgs>>) {
        this.datasets = Output.all(values)
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("pgdutblopocymaqi")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("efbnyukkdfopofdj")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("sufnsamhiqbkrfaw")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("cgtdtutnsjefamhp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value When set to true, Certificate validation will be disabled.
     */
    @JvmName("excwfhoqlptfamka")
    public suspend fun disableCertValidation(`value`: Output<Boolean>) {
        this.disableCertValidation = value
    }

    /**
     * @param value Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
     */
    @JvmName("fsqynnpqplhupbwv")
    public suspend fun headers(`value`: Output<Map<String, String>>) {
        this.headers = value
    }

    /**
     * @param value Timeout for the HTTP request to get a response. Format is in TimeSpan (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00 (1 minute). The range is from 1 to 10 minutes
     */
    @JvmName("mdusvhdpdbjourdn")
    public suspend fun httpRequestTimeout(`value`: Output<Any>) {
        this.httpRequestTimeout = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("mpspirmmwiskxniu")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value List of linked services passed to web endpoint.
     */
    @JvmName("qnfyxahbscdtgces")
    public suspend fun linkedServices(`value`: Output<List<LinkedServiceReferenceArgs>>) {
        this.linkedServices = value
    }

    @JvmName("hueomgsafgscjfpd")
    public suspend fun linkedServices(vararg values: Output<LinkedServiceReferenceArgs>) {
        this.linkedServices = Output.all(values.asList())
    }

    /**
     * @param values List of linked services passed to web endpoint.
     */
    @JvmName("jebvojuwdaripmxh")
    public suspend fun linkedServices(values: List<Output<LinkedServiceReferenceArgs>>) {
        this.linkedServices = Output.all(values)
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("nrfbhnvmijdwnnnc")
    public suspend fun method(`value`: Output<Either<String, WebActivityMethod>>) {
        this.method = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("myerifmwuanlcmmk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("alqjrwnosocrvbof")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("ehnphfhenfdjhwul")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("maxixvesibbanfbh")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Option to disable invoking HTTP GET on location given in response header of a HTTP 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false then continues to invoke HTTP GET call on location given in http response headers.
     */
    @JvmName("dbesytmwnaoqcitm")
    public suspend fun turnOffAsync(`value`: Output<Boolean>) {
        this.turnOffAsync = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'WebActivity'.
     */
    @JvmName("hlqlgnjdlunkuskd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Web activity target endpoint and path. Type: string (or Expression with resultType string).
     */
    @JvmName("obauucyxidwaqboe")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("nsbletiykoybrxfr")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("scadjujrnsjlgeal")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("kdggocldyceyncyf")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Authentication method used for calling the endpoint.
     */
    @JvmName("cppacglkpkotjbwr")
    public suspend fun authentication(`value`: WebActivityAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument Authentication method used for calling the endpoint.
     */
    @JvmName("dsauubtfdgoyfpfy")
    public suspend
    fun authentication(argument: suspend WebActivityAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = WebActivityAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type: string (or Expression with resultType string).
     */
    @JvmName("humelqxtlrckpkjn")
    public suspend fun body(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("pdbednrmxkapdyqn")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("lxmeygsriygpqyhu")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value List of datasets passed to web endpoint.
     */
    @JvmName("kfihgqbjbxwqjvsl")
    public suspend fun datasets(`value`: List<DatasetReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasets = mapped
    }

    /**
     * @param argument List of datasets passed to web endpoint.
     */
    @JvmName("xqqcikmlnupkjtux")
    public suspend fun datasets(argument: List<suspend DatasetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param argument List of datasets passed to web endpoint.
     */
    @JvmName("whsrhpdriwvksekq")
    public suspend fun datasets(vararg argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DatasetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param argument List of datasets passed to web endpoint.
     */
    @JvmName("jlfwwooirgfvfxqy")
    public suspend fun datasets(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DatasetReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.datasets = mapped
    }

    /**
     * @param values List of datasets passed to web endpoint.
     */
    @JvmName("pyejfhcnhdvhstvk")
    public suspend fun datasets(vararg values: DatasetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasets = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("jbatynbacahwkkmu")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("pukvqdrajccsybvj")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("wrovilsmswtcwdri")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("rivkrmpunhvxqeyq")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("fpwvumjwbmqmrwug")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("wltbbjghuaaruvwj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value When set to true, Certificate validation will be disabled.
     */
    @JvmName("ronytywuapxohhuk")
    public suspend fun disableCertValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableCertValidation = mapped
    }

    /**
     * @param value Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
     */
    @JvmName("ofuvdyigrfsrhncm")
    public suspend fun headers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type: string (or Expression with resultType string).
     */
    @JvmName("watsljdbihsrswbp")
    public fun headers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Timeout for the HTTP request to get a response. Format is in TimeSpan (hh:mm:ss). This value is the timeout to get a response, not the activity timeout. The default value is 00:01:00 (1 minute). The range is from 1 to 10 minutes
     */
    @JvmName("sbhhvoafmonghlqq")
    public suspend fun httpRequestTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRequestTimeout = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("bepvlavosdyabxhb")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("hpbymbhmklcwnokj")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value List of linked services passed to web endpoint.
     */
    @JvmName("jpmfnvkgwtbyogor")
    public suspend fun linkedServices(`value`: List<LinkedServiceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServices = mapped
    }

    /**
     * @param argument List of linked services passed to web endpoint.
     */
    @JvmName("oehjycqmbtimjnpk")
    public suspend
    fun linkedServices(argument: List<suspend LinkedServiceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param argument List of linked services passed to web endpoint.
     */
    @JvmName("ykpwxynglmoftomc")
    public suspend fun linkedServices(
        vararg
        argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LinkedServiceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param argument List of linked services passed to web endpoint.
     */
    @JvmName("oqnsurlkxbbfqgwn")
    public suspend
    fun linkedServices(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedServices = mapped
    }

    /**
     * @param values List of linked services passed to web endpoint.
     */
    @JvmName("unqhxbqaskxxsyxq")
    public suspend fun linkedServices(vararg values: LinkedServiceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServices = mapped
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("mtwfkweqsybyhkpf")
    public suspend fun method(`value`: Either<String, WebActivityMethod>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("rrhriucvtaligina")
    public fun method(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebActivityMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Rest API method for target endpoint.
     */
    @JvmName("jvlekeqvrjgbwhit")
    public fun method(`value`: WebActivityMethod) {
        val toBeMapped = Either.ofRight<String, WebActivityMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("phoxpdnxniwqtyax")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("ghxmsbklyotxemkw")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("oosvlqbwthpnvxqu")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("rmiusodlfmmdvpad")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("jrpwdurdmpkmdhwk")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("jyokpnajjcdpmeie")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("kbierktkfcnwgxoa")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("yicetnyxtepfndtx")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("coifeogaontbihif")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Option to disable invoking HTTP GET on location given in response header of a HTTP 202 Response. If set true, it stops invoking HTTP GET on http location given in response header. If set false then continues to invoke HTTP GET call on location given in http response headers.
     */
    @JvmName("jhrhhgdmicdvnkpq")
    public suspend fun turnOffAsync(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.turnOffAsync = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'WebActivity'.
     */
    @JvmName("pvnubciskwotosow")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Web activity target endpoint and path. Type: string (or Expression with resultType string).
     */
    @JvmName("aojfjamiuyauagvb")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("irbuwtlbhfhorphu")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("lacpaxiwomidurdn")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("mdvvfhdaigxaktrl")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("csnntswafgligrcw")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("hpioadyuubftrjet")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): WebActivityArgs = WebActivityArgs(
        authentication = authentication,
        body = body,
        connectVia = connectVia,
        datasets = datasets,
        dependsOn = dependsOn,
        description = description,
        disableCertValidation = disableCertValidation,
        headers = headers,
        httpRequestTimeout = httpRequestTimeout,
        linkedServiceName = linkedServiceName,
        linkedServices = linkedServices,
        method = method ?: throw PulumiNullFieldException("method"),
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        state = state,
        turnOffAsync = turnOffAsync,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        userProperties = userProperties,
    )
}
