@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ZendeskLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ZendeskAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Zendesk.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property apiToken The api token for the Zendesk source.
 * @property authenticationType The authentication type to use.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The password of the Zendesk source.
 * @property type Type of linked service.
 * Expected value is 'Zendesk'.
 * @property url The url to connect Zendesk source. Type: string (or Expression with resultType string).
 * @property userName The username of the Zendesk source. Type: string (or Expression with resultType string).
 */
public data class ZendeskLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val apiToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val authenticationType: Output<Either<String, ZendeskAuthenticationType>>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val type: Output<String>,
    public val url: Output<Any>,
    public val userName: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ZendeskLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ZendeskLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.ZendeskLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .apiToken(
                apiToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZendeskLinkedServiceArgs].
 */
@PulumiTagMarker
public class ZendeskLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var apiToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var authenticationType: Output<Either<String, ZendeskAuthenticationType>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var url: Output<Any>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("qgiaaxwdfichnobn")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("piyvquhkyfdurlhs")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("plwystckuvwrsluy")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The api token for the Zendesk source.
     */
    @JvmName("etsdfiyicoedsxjp")
    public suspend
    fun apiToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.apiToken = value
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("cwxkvjlkfvevxdhx")
    public suspend
    fun authenticationType(`value`: Output<Either<String, ZendeskAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ghblkrgukeibmknw")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("hkjiwedoyvajnnrw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("xrnlbsrafvwrjwfk")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("porebssylmwqomyj")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password of the Zendesk source.
     */
    @JvmName("wxjhxqjjvugbsfok")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Zendesk'.
     */
    @JvmName("aibqyjsmkaeufqvt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The url to connect Zendesk source. Type: string (or Expression with resultType string).
     */
    @JvmName("dcvpypllyeobasag")
    public suspend fun url(`value`: Output<Any>) {
        this.url = value
    }

    /**
     * @param value The username of the Zendesk source. Type: string (or Expression with resultType string).
     */
    @JvmName("gfxaxhhuarhdvhvx")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("xwnsgwhssgsvokit")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("srvmmanscqypobsw")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The api token for the Zendesk source.
     */
    @JvmName("hrpslxqijdcewypp")
    public suspend
    fun apiToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiToken = mapped
    }

    /**
     * @param value The api token for the Zendesk source.
     */
    @JvmName("aheikxntvxkncned")
    public fun apiToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiToken = mapped
    }

    /**
     * @param value The api token for the Zendesk source.
     */
    @JvmName("gimtmyhoqofetynb")
    public fun apiToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiToken = mapped
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("rvtnvvgqtvibrrco")
    public suspend fun authenticationType(`value`: Either<String, ZendeskAuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("bihumupqsswxcpnd")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZendeskAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication type to use.
     */
    @JvmName("afqlmofayiukiynr")
    public fun authenticationType(`value`: ZendeskAuthenticationType) {
        val toBeMapped = Either.ofRight<String, ZendeskAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("tmaouqxpgedtdmot")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("vntrjgqibdldqdau")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("kvccywjfdldbgnuh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("llvgjadntxwajnxh")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("upqoveliftefeqjd")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("lyjupdojkkbajxxd")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("pptasgxgldwhkjck")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password of the Zendesk source.
     */
    @JvmName("ldpcvqbyluourkcy")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password of the Zendesk source.
     */
    @JvmName("peyaiflyjnnfoell")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password of the Zendesk source.
     */
    @JvmName("qfwrwomwbglympgi")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Zendesk'.
     */
    @JvmName("acaaigqajxlafmfv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The url to connect Zendesk source. Type: string (or Expression with resultType string).
     */
    @JvmName("cckgyluhivjpdvck")
    public suspend fun url(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value The username of the Zendesk source. Type: string (or Expression with resultType string).
     */
    @JvmName("bnxlxfvfrlvrqvud")
    public suspend fun userName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ZendeskLinkedServiceArgs = ZendeskLinkedServiceArgs(
        annotations = annotations,
        apiToken = apiToken,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        url = url ?: throw PulumiNullFieldException("url"),
        userName = userName,
    )
}
