@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Azure Databricks Delta Lake export command settings.
 * @property dateFormat Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
 * @property timestampFormat Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
 * @property type The export setting type.
 * Expected value is 'AzureDatabricksDeltaLakeExportCommand'.
 */
public data class AzureDatabricksDeltaLakeExportCommandResponse(
    public val dateFormat: Any? = null,
    public val timestampFormat: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDatabricksDeltaLakeExportCommandResponse):
            AzureDatabricksDeltaLakeExportCommandResponse =
            AzureDatabricksDeltaLakeExportCommandResponse(
                dateFormat = javaType.dateFormat().map({ args0 -> args0 }).orElse(null),
                timestampFormat = javaType.timestampFormat().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
