@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Azure Key Vault secret reference.
 * @property secretName The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
 * @property secretVersion The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
 * @property store The Azure Key Vault linked service reference.
 * @property type Type of the secret.
 * Expected value is 'AzureKeyVaultSecret'.
 */
public data class AzureKeyVaultSecretReferenceResponse(
    public val secretName: Any,
    public val secretVersion: Any? = null,
    public val store: LinkedServiceReferenceResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureKeyVaultSecretReferenceResponse):
            AzureKeyVaultSecretReferenceResponse = AzureKeyVaultSecretReferenceResponse(
            secretName = javaType.secretName(),
            secretVersion = javaType.secretVersion().map({ args0 -> args0 }).orElse(null),
            store = javaType.store().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
