@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Synapse Analytics (Artifacts) linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Required to specify MSI, if using system assigned managed identity as authentication method. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property endpoint https://<workspacename>.dev.azuresynapse.net, Azure Synapse Analytics workspace URL. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'AzureSynapseArtifacts'.
 * @property workspaceResourceId The resource ID of the Synapse workspace. The format should be: /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}. Type: string (or Expression with resultType string).
 */
public data class AzureSynapseArtifactsLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authentication: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val endpoint: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val type: String,
    public val workspaceResourceId: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureSynapseArtifactsLinkedServiceResponse):
            AzureSynapseArtifactsLinkedServiceResponse = AzureSynapseArtifactsLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            type = javaType.type(),
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
