@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that runs every time the selected Blob container changes.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property folderPath The path of the container/folder that will trigger the pipeline.
 * @property linkedService The Azure Storage linked service reference.
 * @property maxConcurrency The max number of parallel files to handle when it is triggered.
 * @property pipelines Pipelines that need to be started.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property type Trigger type.
 * Expected value is 'BlobTrigger'.
 */
public data class BlobTriggerResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val folderPath: String,
    public val linkedService: LinkedServiceReferenceResponse,
    public val maxConcurrency: Int,
    public val pipelines: List<TriggerPipelineReferenceResponse>? = null,
    public val runtimeState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.BlobTriggerResponse):
            BlobTriggerResponse = BlobTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath(),
            linkedService = javaType.linkedService().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            maxConcurrency = javaType.maxConcurrency(),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            runtimeState = javaType.runtimeState(),
            type = javaType.type(),
        )
    }
}
