@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Base class for all control activities like IfCondition, ForEach , Until.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Container'.
 * @property userProperties Activity user properties.
 */
public data class ControlActivityResponse(
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ControlActivityResponse):
            ControlActivityResponse = ControlActivityResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
