@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that runs every time a custom event is received.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property events The list of event types that cause this trigger to fire.
 * @property pipelines Pipelines that need to be started.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property scope The ARM resource ID of the Azure Event Grid Topic.
 * @property subjectBeginsWith The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
 * @property subjectEndsWith The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
 * @property type Trigger type.
 * Expected value is 'CustomEventsTrigger'.
 */
public data class CustomEventsTriggerResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val events: List<Any>,
    public val pipelines: List<TriggerPipelineReferenceResponse>? = null,
    public val runtimeState: String,
    public val scope: String,
    public val subjectBeginsWith: String? = null,
    public val subjectEndsWith: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CustomEventsTriggerResponse):
            CustomEventsTriggerResponse = CustomEventsTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            events = javaType.events().map({ args0 -> args0 }),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            runtimeState = javaType.runtimeState(),
            scope = javaType.scope(),
            subjectBeginsWith = javaType.subjectBeginsWith().map({ args0 -> args0 }).orElse(null),
            subjectEndsWith = javaType.subjectEndsWith().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
