@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * DW Copy Command settings.
 * @property additionalOptions Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression with resultType object). Example: "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }
 * @property defaultValues Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT constraint set in the DB, and identity column cannot have a default value. Type: array of objects (or Expression with resultType array of objects).
 */
public data class DWCopyCommandSettingsResponse(
    public val additionalOptions: Map<String, String>? = null,
    public val defaultValues: List<DWCopyCommandDefaultValueResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DWCopyCommandSettingsResponse):
            DWCopyCommandSettingsResponse = DWCopyCommandSettingsResponse(
            additionalOptions = javaType.additionalOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            defaultValues = javaType.defaultValues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DWCopyCommandDefaultValueResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
