@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Nested representation of a complex expression.
 * @property operands List of nested expressions.
 * @property operator Expression operator value Type: string.
 * @property type Type of expressions supported by the system. Type: string.
 * @property value Value for Constant/Field Type: string.
 */
public data class ExpressionV2Response(
    public val operands: List<ExpressionV2Response>? = null,
    public val `operator`: String? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExpressionV2Response):
            ExpressionV2Response = ExpressionV2Response(
            operands = javaType.operands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ExpressionV2Response.Companion.toKotlin(args0)
                })
            }),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
