@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * File server read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileFilter Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression with resultType string).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'FileServerReadSettings'.
 * @property wildcardFileName FileServer wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath FileServer wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class FileServerReadSettingsResponse(
    public val deleteFilesAfterCompletion: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val enablePartitionDiscovery: Any? = null,
    public val fileFilter: Any? = null,
    public val fileListPath: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val modifiedDatetimeEnd: Any? = null,
    public val modifiedDatetimeStart: Any? = null,
    public val partitionRootPath: Any? = null,
    public val recursive: Any? = null,
    public val type: String,
    public val wildcardFileName: Any? = null,
    public val wildcardFolderPath: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FileServerReadSettingsResponse):
            FileServerReadSettingsResponse = FileServerReadSettingsResponse(
            deleteFilesAfterCompletion = javaType.deleteFilesAfterCompletion().map({ args0 ->
                args0
            }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            enablePartitionDiscovery = javaType.enablePartitionDiscovery().map({ args0 -> args0 }).orElse(null),
            fileFilter = javaType.fileFilter().map({ args0 -> args0 }).orElse(null),
            fileListPath = javaType.fileListPath().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            modifiedDatetimeEnd = javaType.modifiedDatetimeEnd().map({ args0 -> args0 }).orElse(null),
            modifiedDatetimeStart = javaType.modifiedDatetimeStart().map({ args0 -> args0 }).orElse(null),
            partitionRootPath = javaType.partitionRootPath().map({ args0 -> args0 }).orElse(null),
            recursive = javaType.recursive().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            wildcardFileName = javaType.wildcardFileName().map({ args0 -> args0 }).orElse(null),
            wildcardFolderPath = javaType.wildcardFolderPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
